/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.tch;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.reports.salesreports.render.tch.TchSalesReportTestBase;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import org.junit.Assert;
import org.junit.Test;

public class TchSubsidizedCCReportTest
extends TchSalesReportTestBase {
    @Test
    public void testReport() throws Exception {
        this.issueDate = new SimpleDateFormat("yyyy-MM-dd").parse("2016-01-01");
        this.createProfiles();
        String productUid = this.createSubsidizedProduct("101", "SU", 100.0, ProductStatus.SELL, null, null, true, "airport KGD", "SU", "VV");
        EntityContainer bookingCtr = BookingDao.findProductByUid((String)productUid).getContainer();
        Product prod = (Product)BookingHelper.findProductByUid((String)productUid, (BookingFile)((BookingFile)bookingCtr.getEntity()));
        for (AirProductContractRelationData relation : AirProductHelper.getContractRelations((Product)prod)) {
            for (ProductFop fop : relation.getFops()) {
                fop.setType(PaymentType.CREDIT_CARD);
            }
        }
        EntityStorage.get().save(bookingCtr, false);
        this.createReport(new File(this.getOutFolder(), "xtr-3618-main.xls"));
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("testdata/xtr-3618-main.xls")), (File)new File(this.getOutFolder(), "xtr-3618-main.xls"));
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }
}

