/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.tch;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.reports.salesreports.render.tch.TchSalesReportTestBase;
import java.io.File;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import org.junit.Assert;
import org.junit.Test;

public class XTR8848ChildTicketTest
extends TchSalesReportTestBase {
    private final String airlineNumber1 = "026";

    @Test
    public void testChildTicket() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        this.issueDate = sdf.parse("2019-02-01");
        this.createProfiles();
        String productUid = this.createProduct("001", 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 0.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, true, "026");
        ProductSearchResult psr = BookingDao.findProductByUid((String)productUid);
        Product product = (Product)psr.getProduct();
        product.getFares().clear();
        product.getTaxes().clear();
        product.setContractRulesApplied(false);
        AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)BigDecimal.ZERO);
        AirProductHelper.setBaseFare((Product)product, (Money)SystemHelper.getMoney((double)0.0, (String)DictHelper.getEquivCurrency()));
        AirProductHelper.getVendorFops((Product)product).forEach(fop -> {
            fop.getAmount().setValue(BigDecimal.ZERO);
            fop.getFares().clear();
            fop.getTaxes().clear();
        });
        EntityStorage.get().save(psr.getContainer(), true);
        File outFile = new File(this.getOutFolder(), "XTR8848.xls");
        this.createReport(outFile);
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("testdata/XTR8848-expected.xls")), (File)outFile);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }

    @Override
    protected URL getDictionariesSetupFile() {
        return ((Object)((Object)this)).getClass().getResource("tchSalesReportTestDictionaries.xml");
    }
}

