/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.tch;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TchCreditCardAccompanyingDocumentType;
import com.gridnine.xtrip.common.model.booking.commission.CalculationType;
import com.gridnine.xtrip.common.model.booking.commission.FeeType;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.model.test.TestCommissionCategoryBuilder;
import com.gridnine.xtrip.server.model.test.TestContractBuilderBuilder;
import com.gridnine.xtrip.server.model.test.TestFeePropertiesBuilder;
import com.gridnine.xtrip.server.reports.salesreports.render.tch.TchSalesReportTestBase;
import java.io.File;
import java.net.URL;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class Xtr3991Test
extends TchSalesReportTestBase {
    private final String airlineNumber2 = "027";

    @Test
    public void testReport() throws Exception {
        this.issueDate = this.df.parse("2015-02-02");
        this.createProfiles();
        this.ccAccompanyingDocumentType = TchCreditCardAccompanyingDocumentType.C98_AUTOMATIC;
        this.createProduct("0001", 0, "testAirlineCode2", (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, null, PaymentType.CREDIT_CARD_TCH, ProductCategory.AIR, null, false, "027");
        this.createProduct("0002", 0, "testAirlineCode2", (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, null, PaymentType.CREDIT_CARD_TCH, ProductCategory.AIR, null, true, "027");
        this.ccAccompanyingDocumentType = TchCreditCardAccompanyingDocumentType.C98_MANUAL;
        this.createProduct("0003", 0, "testAirlineCode2", (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, null, PaymentType.CREDIT_CARD_TCH, ProductCategory.AIR, null, true, "027");
        this.ccAccompanyingDocumentType = TchCreditCardAccompanyingDocumentType.A4_AUTOMATIC;
        this.createProduct("0004", 0, "testAirlineCode2", (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, null, PaymentType.CREDIT_CARD_TCH, ProductCategory.AIR, null, true, "027");
        File outFile = new File(this.getOutFolder(), "xtr3991.xls");
        Date startDate = this.df.parse("2015-02-01");
        Date endDate = this.df.parse("2015-02-10");
        this.createReport(startDate, endDate, outFile);
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("testdata/xtr3991.xls")), (File)outFile);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }

    @Override
    protected void createProfiles() throws Exception {
        super.createProfiles();
        DictionaryReference category = ((TestCommissionCategoryBuilder)((TestCommissionCategoryBuilder)new TestCommissionCategoryBuilder().code("client-fee")).translation("Client Fee")).create();
        EntityReference fee = new TestFeePropertiesBuilder().calculationType(CalculationType.TICKET).calculationType(Operation.SELL).category(category).displayName("Client fee").productTypes(new ProductType[]{ProductType.AIR_TICKET}).type(FeeType.STANDARD).create().toReference();
        new TestContractBuilderBuilder().contractType(ContractType.CLIENT).airFee(100.0, "RUB", fee).name("Client Contract").supplier(this.agencyContainer.toReference()).customer(this.clientContainer.toReference()).create();
    }
}

