/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.tch;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.reports.salesreports.render.tch.TchSalesReportTestBase;
import java.io.File;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import org.junit.Assert;
import org.junit.Test;

public class Xtr8562ExchangeWithPenaltyTest
extends TchSalesReportTestBase {
    private final String airlineNumber1 = "026";

    @Test
    public void testExchange() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        this.issueDate = sdf.parse("2016-07-01");
        this.createProfiles();
        String pr4 = this.createProduct("001", 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, true, "026");
        this.issueDate = sdf.parse("2019-08-01");
        String pr5 = this.createProduct("001", 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.EXCHANGE, pr4, PaymentType.CASH, ProductCategory.AIR, null, true, "026");
        String productUid = this.createProduct("002", 0, "testAirlineCode1", (EntityReference<Organization>)this.tchReference, 100.0, ProductStatus.SELL, pr5, PaymentType.CASH, ProductCategory.AIR, null, true, "026");
        ProductSearchResult psr = BookingDao.findProductByUid((String)productUid);
        Product product = (Product)psr.getProduct();
        product.setPenalty(BigDecimal.valueOf(300L));
        ProductFop fop1 = (ProductFop)AirProductHelper.getVendorContractRelation((Product)product).getFops().get(0);
        fop1.setType(PaymentType.TICKET);
        fop1.setAmount(MoneyHelper.buildMoney((double)200.0, (String)"RUB"));
        fop1.getTaxes().addAll(product.getTaxes());
        fop1.getFares().addAll(product.getFares());
        ProductFop fop2 = new ProductFop();
        fop2.setType(PaymentType.CREDIT_CARD_TCH);
        fop2.setCard(new Card());
        fop2.getCard().setVendor(CardVendor.VISA);
        fop2.setAmount(MoneyHelper.buildMoney((double)300.0, (String)"RUB"));
        fop2.setHasPenaltyComponent(true);
        AirProductHelper.getVendorContractRelation((Product)product).getFops().add(fop2);
        EntityStorage.get().save(psr.getContainer(), true);
        File outFile = new File(this.getOutFolder(), "xtr8562-1.xls");
        this.createReport(outFile);
        String res = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource("testdata/xtr8562-1.xls")), (File)outFile);
        Assert.assertTrue((String)res, (res == null ? 1 : 0) != 0);
    }

    @Override
    protected URL getDictionariesSetupFile() {
        return ((Object)((Object)this)).getClass().getResource("tchSalesReportTestDictionaries.xml");
    }
}

