/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.template.airtickets;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.RequestedParameterCustomType;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.GeneralProductsTemplateReportPageDescription;
import com.gridnine.xtrip.common.reports.model.TemplateReportPageCustomParameterValue;
import com.gridnine.xtrip.common.reports.model.TemplateReportPageTemplate;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.system.model.SortOrderData;
import com.gridnine.xtrip.server.reports.salesreports.render.template.airtickets.AirTicketsTemplateReportTestBase;
import org.junit.Test;

public class UfsAirTicketsTemplateReportBasicTest
extends AirTicketsTemplateReportTestBase {
    protected EntityReference<AirTicketsTemplateReportDescription> descriptionReference;

    @Test
    public void testReport() throws Exception {
        this.issueDate = this.sdf.parse("2010-01-05");
        this.createProfiles();
        this.createDescription();
        this.createProduct("001", ProductStatus.SELL, null);
        DictionaryReference oldCarrier = this.validatingCarrier;
        this.validatingCarrier = new AirlineReference("VV");
        this.createProduct("002", ProductStatus.SELL, null);
        this.validatingCarrier = oldCarrier;
        DictionaryReference oldLocation = this.arrivalLocation;
        this.arrivalLocation = new GeoLocationReference("KJA");
        this.createProduct("003", ProductStatus.SELL, null);
        this.arrivalLocation = oldLocation;
        String productUid = this.createProduct("004", ProductStatus.SELL, null);
        this.issueDate = this.sdf.parse("2010-01-06");
        productUid = this.createProduct("004", ProductStatus.REFUND, productUid);
        MCOCategory oldMCOCategory = this.mcoCategory;
        ProductCategory oldProductCategory = this.productCategory;
        this.mcoCategory = MCOCategory.PENALTY;
        this.productCategory = ProductCategory.MCO;
        this.createProduct("104", ProductStatus.SELL, productUid);
        this.mcoCategory = oldMCOCategory;
        this.productCategory = oldProductCategory;
        productUid = this.createProduct("005", ProductStatus.SELL, null);
        this.issueDate = this.sdf.parse("2010-01-07");
        productUid = this.createProduct("005", ProductStatus.EXCHANGE, productUid);
        this.createProduct("006", ProductStatus.SELL, productUid);
        oldMCOCategory = this.mcoCategory;
        oldProductCategory = this.productCategory;
        this.mcoCategory = MCOCategory.PENALTY;
        this.productCategory = ProductCategory.MCO;
        this.createProduct("106", ProductStatus.SELL, productUid);
        this.mcoCategory = oldMCOCategory;
        this.productCategory = oldProductCategory;
        AirTicketsTemplateReportParameters parameters = new AirTicketsTemplateReportParameters();
        parameters.setDescription(this.descriptionReference);
        parameters.setAgency(this.agencyReference);
        parameters.setPeriodBegin(this.sdf.parse("2010-01-01"));
        parameters.setPeriodEnd(this.sdf.parse("2010-01-10"));
        ContentType contentType = this.getContentType();
        if (contentType == ContentType.EXCEL) {
            this.createReport(parameters, "ufs.xls", ContentType.EXCEL);
        } else {
            this.createReport(parameters, "ufs.pdf", ContentType.PDF);
        }
        this.exportData("ufs.xml");
    }

    protected ContentType getContentType() {
        return ContentType.JASPERPRINT;
    }

    protected void createDescription() throws Exception {
        EntityContainer ctr = new EntityContainer(AirTicketsTemplateReportDescription.class, "reportDescription");
        AirTicketsTemplateReportDescription description = (AirTicketsTemplateReportDescription)ctr.getEntity();
        description.setTitle("UFS report");
        description.getGlobalCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.agency.name(), (Object)this.agencyReference));
        TemplateReportPageTemplate template = new TemplateReportPageTemplate();
        template.setName("Registry Template");
        template.setContent(this.getJasperTemplate("ufs-report-template-registry.xml"));
        description.getTemplates().add(template);
        description.getPages().add(this.createDescription(true, template));
        description.getPages().add(this.createDescription(false, template));
        EntityStorage.get().save(ctr, true);
        this.descriptionReference = ctr.toReference();
    }

    private GeneralProductsTemplateReportPageDescription createDescription(boolean mvl, TemplateReportPageTemplate template) {
        GeneralProductsTemplateReportPageDescription pageDescription = new GeneralProductsTemplateReportPageDescription();
        pageDescription.setName("MVL");
        pageDescription.setTemplate(template);
        TemplateReportPageCustomParameterValue param = new TemplateReportPageCustomParameterValue();
        param.setKey("MVL");
        param.setType(RequestedParameterCustomType.STRING);
        param.setValue((Object)(mvl ? Boolean.TRUE : Boolean.FALSE));
        pageDescription.getCustomParameters().add(param);
        if (mvl) {
            pageDescription.getPageCriterions().add(SearchCriterion.eq((String)"transportationType", (Object)TransportationType.INTERNATIONAL));
        } else {
            pageDescription.getPageCriterions().add(SearchCriterion.ne((String)"transportationType", (Object)TransportationType.INTERNATIONAL));
        }
        SortOrderData order = new SortOrderData();
        order.setOrder(SortOrder.ASC);
        order.setPropertyName("validatingCarrier");
        pageDescription.getSortOrders().add(order);
        order = new SortOrderData();
        order.setOrder(SortOrder.ASC);
        order.setPropertyName("sortingTicketNumber");
        pageDescription.getSortOrders().add(order);
        order = new SortOrderData();
        order.setOrder(SortOrder.ASC);
        order.setPropertyName("productCategory");
        pageDescription.getSortOrders().add(order);
        order = new SortOrderData();
        order.setOrder(SortOrder.DESC);
        order.setPropertyName("mcoCategory");
        pageDescription.getSortOrders().add(order);
        order = new SortOrderData();
        order.setOrder(SortOrder.ASC);
        order.setPropertyName("issueDate");
        pageDescription.getSortOrders().add(order);
        order = new SortOrderData();
        order.setOrder(SortOrder.ASC);
        order.setPropertyName("status");
        pageDescription.getSortOrders().add(order);
        return pageDescription;
    }
}

