/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.template.allproducts;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.RequestedParameterCustomType;
import com.gridnine.xtrip.common.reports.model.AllProductsTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.AllProductsTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.GeneralProductsTemplateReportPageDescription;
import com.gridnine.xtrip.common.reports.model.TemplateReportPageCustomParameterValue;
import com.gridnine.xtrip.common.reports.model.TemplateReportPageTemplate;
import com.gridnine.xtrip.common.reports.render.agentreport.AgentReportTicket;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.system.model.SortOrderData;
import com.gridnine.xtrip.server.reports.salesreports.render.template.allproducts.AllProductsTemplateReportTestBase;
import java.io.File;
import java.math.BigDecimal;
import org.junit.Test;

public class BalServiceAllProductsTemplateReportBasicTest
extends AllProductsTemplateReportTestBase {
    private EntityReference<AllProductsTemplateReportDescription> descriptionReference;

    @Test
    public void testReport() throws Exception {
        this.issueDate = this.sdf.parse("2010-01-05");
        this.createProfiles();
        this.createDescription();
        this.createProduct("001", ProductStatus.SELL, null);
        this.createProduct("004", ProductStatus.SELL, null);
        EntityReference oldBlankOwner = this.blankOwner;
        EntityReference oldSupplier = this.supplierRef;
        this.blankOwner = this.suReference;
        this.supplierRef = this.suReference;
        this.createProduct("002", ProductStatus.SELL, null);
        this.createProduct("003", ProductStatus.SELL, null);
        this.blankOwner = oldBlankOwner;
        this.supplierRef = oldSupplier;
        oldBlankOwner = this.blankOwner;
        oldSupplier = this.supplierRef;
        this.blankOwner = this.s7Reference;
        this.supplierRef = this.s7Reference;
        this.createProduct("005", ProductStatus.SELL, null);
        this.createProduct("006", ProductStatus.SELL, null);
        this.blankOwner = oldBlankOwner;
        this.supplierRef = oldSupplier;
        String productUid = this.createProduct("007", ProductStatus.SELL, null);
        this.issueDate = this.sdf.parse("2010-01-06");
        productUid = this.createProduct("007", ProductStatus.REFUND, productUid);
        MCOCategory oldMCOCategory = this.mcoCategory;
        ProductCategory oldProductCategory = this.productCategory;
        this.mcoCategory = MCOCategory.PENALTY;
        this.productCategory = ProductCategory.MCO;
        this.createProduct("107", ProductStatus.SELL, productUid);
        this.mcoCategory = oldMCOCategory;
        this.productCategory = oldProductCategory;
        productUid = this.createProduct("008", ProductStatus.SELL, null);
        this.issueDate = this.sdf.parse("2010-01-07");
        productUid = this.createProduct("008", ProductStatus.EXCHANGE, productUid);
        this.createProduct("009", ProductStatus.SELL, productUid);
        oldMCOCategory = this.mcoCategory;
        oldProductCategory = this.productCategory;
        this.mcoCategory = MCOCategory.PENALTY;
        this.productCategory = ProductCategory.MCO;
        this.createProduct("109", ProductStatus.SELL, productUid);
        this.mcoCategory = oldMCOCategory;
        this.productCategory = oldProductCategory;
        AllProductsTemplateReportParameters parameters = new AllProductsTemplateReportParameters();
        parameters.setDescription(this.descriptionReference);
        parameters.setAgency(this.agencyReference);
        parameters.setPeriodBegin(this.sdf.parse("2010-01-01"));
        parameters.setPeriodEnd(this.sdf.parse("2010-01-10"));
        parameters.setAgent(this.agentRef);
        parameters.getRequestedParameters().add(this.createParameter("START_CASH_BALANCE", BigDecimal.TEN));
        parameters.getRequestedParameters().add(this.createParameter("FROM_OTHER_CASHIER", BigDecimal.valueOf(9L)));
        parameters.getRequestedParameters().add(this.createParameter("ENCASHMENT", BigDecimal.valueOf(15L)));
        parameters.getRequestedParameters().add(this.createParameter("TO_OTHER_CASHIER", BigDecimal.valueOf(3L)));
        File outputFile = this.createReport(parameters, "bal-service.pdf", ContentType.PDF);
    }

    private void createDescription() throws Exception {
        EntityContainer ctr = new EntityContainer(AllProductsTemplateReportDescription.class, "bal-service-report");
        AllProductsTemplateReportDescription description = (AllProductsTemplateReportDescription)ctr.getEntity();
        description.setTitle("UFS report");
        description.getGlobalCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.agency.name(), (Object)this.agencyReference));
        TemplateReportPageTemplate summaryTemplate = new TemplateReportPageTemplate();
        summaryTemplate.setContent(this.getJasperTemplate("bal-service-report-template-summary.xml"));
        summaryTemplate.setName("Summary Template");
        description.getTemplates().add(summaryTemplate);
        TemplateReportPageTemplate registryTemplate = new TemplateReportPageTemplate();
        registryTemplate.setContent(this.getJasperTemplate("bal-service-report-template-registry.xml"));
        registryTemplate.setName("Registry Template");
        description.getTemplates().add(registryTemplate);
        GeneralProductsTemplateReportPageDescription pageDescription = new GeneralProductsTemplateReportPageDescription();
        pageDescription.setName("Summary");
        pageDescription.setTemplate(summaryTemplate);
        pageDescription.getPageCriterions().add(SearchCriterion.eq((String)AgentReportTicket.Property.issuedInReportPeriod.name(), (Object)Boolean.TRUE));
        SortOrderData order = new SortOrderData();
        order.setOrder(SortOrder.ASC);
        order.setPropertyName(AgentReportTicket.Property.groupName.name());
        pageDescription.getSortOrders().add(order);
        description.getPages().add(pageDescription);
        description.getPages().add(this.createRegistryDescription(false, registryTemplate));
        description.getPages().add(this.createRegistryDescription(true, registryTemplate));
        EntityStorage.get().save(ctr, true);
        this.descriptionReference = ctr.toReference();
    }

    private GeneralProductsTemplateReportPageDescription createRegistryDescription(boolean refund, TemplateReportPageTemplate registryTemplate) {
        GeneralProductsTemplateReportPageDescription pageDescription = new GeneralProductsTemplateReportPageDescription();
        pageDescription.setName(refund ? "Refund Registry" : "Sell Registry");
        pageDescription.setTemplate(registryTemplate);
        TemplateReportPageCustomParameterValue param = new TemplateReportPageCustomParameterValue();
        param.setKey("STATUS");
        param.setType(RequestedParameterCustomType.STRING);
        param.setValue((Object)(refund ? "REFUND" : "SELL"));
        pageDescription.getCustomParameters().add(param);
        pageDescription.getPageCriterions().add(SearchCriterion.eq((String)AgentReportTicket.Property.issuedInReportPeriod.name(), (Object)Boolean.TRUE));
        if (refund) {
            pageDescription.getPageCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)AgentReportTicket.Property.refundPenaltyMCO.name(), (Object)Boolean.TRUE), SearchCriterion.eq((String)AgentReportTicket.Property.refundReceiptMCO.name(), (Object)Boolean.TRUE), SearchCriterion.eq((String)AgentReportTicket.Property.status.name(), (Object)ProductStatus.REFUND)}));
        } else {
            pageDescription.getPageCriterions().add(SearchCriterion.eq((String)AgentReportTicket.Property.refundPenaltyMCO.name(), (Object)Boolean.FALSE));
            pageDescription.getPageCriterions().add(SearchCriterion.eq((String)AgentReportTicket.Property.refundReceiptMCO.name(), (Object)Boolean.FALSE));
            pageDescription.getPageCriterions().add(SearchCriterion.ne((String)AgentReportTicket.Property.status.name(), (Object)ProductStatus.REFUND));
        }
        SortOrderData order = new SortOrderData();
        order.setOrder(SortOrder.ASC);
        order.setPropertyName(AgentReportTicket.Property.groupName.name());
        pageDescription.getSortOrders().add(order);
        order = new SortOrderData();
        order.setOrder(SortOrder.ASC);
        order.setPropertyName(AgentReportTicket.Property.sortingTicketNumber.name());
        pageDescription.getSortOrders().add(order);
        order = new SortOrderData();
        order.setOrder(SortOrder.ASC);
        order.setPropertyName(AgentReportTicket.Property.productCategory.name());
        pageDescription.getSortOrders().add(order);
        order = new SortOrderData();
        order.setOrder(SortOrder.DESC);
        order.setPropertyName(AgentReportTicket.Property.mcoCategory.name());
        pageDescription.getSortOrders().add(order);
        order = new SortOrderData();
        order.setOrder(SortOrder.ASC);
        order.setPropertyName(AgentReportTicket.Property.issueDate.name());
        pageDescription.getSortOrders().add(order);
        order = new SortOrderData();
        order.setOrder(SortOrder.ASC);
        order.setPropertyName(AgentReportTicket.Property.status.name());
        pageDescription.getSortOrders().add(order);
        return pageDescription;
    }
}

