/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.template.common;

import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.commission.ReturnCase;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.booking.commission.RouteType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CommissionCategory;
import com.gridnine.xtrip.common.model.dict.CommissionCategoryReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.Preference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.ExportedObjectsBundle;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.RequestedParameterValue;
import com.gridnine.xtrip.common.model.system.exchange.ExportType;
import com.gridnine.xtrip.common.model.system.exchange.ItemExportSettings;
import com.gridnine.xtrip.common.model.system.exchange.ItemType;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.AllProductsTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.AllProductsTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.BaseSingleFileTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.IndexBasedTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.IndexBasedTemplateReportDocument;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.model.tasks.AsyncServerTask;
import com.gridnine.xtrip.server.model.tasks.standard.ExportObjectsTask;
import com.gridnine.xtrip.server.reports.prepare.ReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.agentreport.RenderAgentReportTestBase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JasperReport;

public abstract class TemplateReportTestBase
extends RenderAgentReportTestBase {
    protected SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    protected Date issueDate;
    protected EntityReference<Person> agentRef = new EntityReference("test_director_container_uid", Person.class, "Test Person");
    protected EntityReference<FeeProperties> sellFeeRef;
    protected EntityReference<FeeProperties> refundFeeRef;
    protected EntityReference<CommissionProperties> commissionRef;
    protected EntityReference<Contract> supplierContractRef;
    protected EntityReference<Contract> subagentContractRef;
    protected EntityReference<Contract> clientContractRef;
    protected int conjunctionsCount = 0;
    protected DictionaryReference<Airline> validatingCarrier = new AirlineReference("SU");
    protected EntityReference<Organization> blankOwner;
    protected double fare = 100.0;
    protected double ruTaxAmount = 50.0;
    protected double yqTaxAmount = 50.0;
    protected Double bspGdsCommissionRate;
    protected Double bspGdsCommisionValue;
    protected ProductCategory productCategory = ProductCategory.AIR;
    protected EntityReference<Organization> supplierRef;
    protected MCOCategory mcoCategory = null;
    protected String validatorCode = "99143332";
    protected boolean eticket = true;
    protected BigDecimal penalty = BigDecimal.ZERO;
    protected PaymentType paymentType = PaymentType.CASH;
    protected DictionaryReference<Airline> segmentAirline = this.validatingCarrier;
    protected DictionaryReference<GeoLocation> arrivalLocation = new GeoLocationReference("PAR");
    protected DictionaryReference<GeoLocation> departureLocation = new GeoLocationReference("MOW");
    protected EntityReference<SalesPoint> salesPointRef;
    protected String yqTaxCode = "YQ";

    protected String createProduct(String ticketNo, ProductStatus status, String relUid) throws Exception {
        Airline carrier;
        EntityContainer bfc = null;
        Product product = null;
        if (!TextUtil.isBlank((String)relUid)) {
            ProductSearchResult searchResult = BookingDao.findProductByUid((String)relUid);
            bfc = searchResult.getContainer();
            Reservation reservation = searchResult.getReservation();
            this.setRecordLocator(reservation, GdsName.SABRE);
            product = new Product();
            product.setTicketType(TicketType.OWN);
            product.setTariffType(TariffType.REGULAR);
            product.setValidatorCode("12345678");
            reservation.getProducts().add(product);
            product.setReservation(reservation);
            Product relatedProduct = (Product)searchResult.getProduct();
            if (this.productCategory == ProductCategory.AIR) {
                if (status == ProductStatus.REFUND || status == ProductStatus.SELL || status == ProductStatus.EXCHANGE) {
                    product.setPreviousProduct(relatedProduct);
                    relatedProduct.setNextProduct(product);
                } else {
                    product.setNextProduct(relatedProduct);
                }
            } else {
                product.getRelatedProducts().add(relatedProduct);
            }
        } else {
            bfc = new EntityContainer(BookingFile.class);
            String user = LogicalStorage.get().getUser();
            bfc.setCreated(new Date());
            bfc.setCreatedBy(user);
            bfc.setModified(new Date());
            bfc.setModifiedBy(user);
            BookingFile bf = (BookingFile)bfc.getEntity();
            Reservation reservation = new Reservation();
            this.setRecordLocator(reservation, GdsName.SABRE);
            bf.getReservations().add(reservation);
            reservation.setBookingFile(bf);
            product = new Product();
            product.setTicketType(TicketType.OWN);
            product.setTariffType(TariffType.REGULAR);
            product.setValidatorCode("12345678");
            reservation.getProducts().add(product);
            product.setReservation(reservation);
        }
        product.setSalesPoint(this.salesPointRef);
        product.setCashier(this.agentRef);
        BookingFile bf = (BookingFile)bfc.getEntity();
        bf.setCustomerProfile(this.clientReference);
        Traveller traveller = new Traveller();
        traveller.setName("Test Person");
        bf.getTravellers().add(traveller);
        product.setTraveller(traveller);
        product.setBlankOwnerRef(this.blankOwner);
        EntityContainer ctr = EntityStorage.get().resolve(this.blankOwner);
        if (ctr != null && ((Organization)ctr.getEntity()).getAirline() != null && (carrier = (Airline)DictionaryCache.get().resolveReference(((Organization)ctr.getEntity()).getAirline())) != null) {
            product.setBlankOwnerNumber(carrier.getAirlineNumber());
        }
        product.setCarrier(this.validatingCarrier);
        bf.setAgency(this.agencyReference);
        AirProductHelper.setSubagency((Product)product, (EntityReference)this.subagencyReference);
        AirProductHelper.setAgency((Product)product, (EntityReference)this.agencyReference);
        AirProductHelper.setSupplier((Product)product, this.supplierRef);
        product.setProductCategory(this.productCategory);
        product.setMcoCategory(this.mcoCategory);
        product.setEticket(this.eticket);
        product.setPenalty(this.penalty);
        if (this.bspGdsCommissionRate != null) {
            product.setBspCommissionRate(this.bspGdsCommissionRate);
        }
        if (this.bspGdsCommisionValue != null) {
            product.setBspCommissionValue(SystemHelper.getMoney((double)this.bspGdsCommisionValue, (String)"RUB"));
        }
        product.setBlankType((DictionaryReference)new BlankTypeReference("BSP ETKT"));
        Money money = new Money();
        money.setCurrency("RUB");
        money.setValue(BigDecimal.valueOf(this.fare));
        AirProductHelper.setBaseFare((Product)product, (Money)money);
        AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)BigDecimal.valueOf(this.fare));
        Tax tax = new Tax();
        tax.setCode("RU");
        tax.setEquivalentAmount(BigDecimal.valueOf(this.ruTaxAmount));
        product.getTaxes().add(tax);
        tax = new Tax();
        tax.setCode(this.yqTaxCode);
        tax.setEquivalentAmount(BigDecimal.valueOf(this.yqTaxAmount));
        product.getTaxes().add(tax);
        product.setStatus(status);
        product.setSystemNumber(ticketNo);
        product.setConjCount(this.conjunctionsCount);
        product.getScns().add(ticketNo);
        product.setIssueDate(this.issueDate);
        product.setCarrierNumber(((Airline)DictionaryCache.get().resolveReference(this.validatingCarrier)).getAirlineNumber());
        ProductFop vendorFop = new ProductFop();
        vendorFop.setType(this.paymentType);
        Segment segment = new Segment();
        segment.setRecordNumber(1);
        segment.setStartDate(this.issueDate);
        segment.setAirline(this.segmentAirline);
        segment.setDepartureLocation(this.departureLocation);
        segment.setArriveLocation(this.arrivalLocation);
        segment.setFareBasis("farebasis");
        segment.setFlightNo("001");
        SegmentTariff sppPsgr = new SegmentTariff();
        sppPsgr.getSegments().add(segment);
        product.getSegmentTariffs().add(sppPsgr);
        segment = new Segment();
        segment.setRecordNumber(2);
        segment.setStartDate(this.issueDate);
        segment.setAirline(this.segmentAirline);
        segment.setDepartureLocation(this.arrivalLocation);
        segment.setArriveLocation(this.departureLocation);
        segment.setFareBasis("farebasis");
        segment.setFlightNo("001");
        sppPsgr = new SegmentTariff();
        sppPsgr.getSegments().add(segment);
        product.getSegmentTariffs().add(sppPsgr);
        if (this.paymentType.equals((Object)PaymentType.CREDIT_CARD)) {
            Card card = new Card();
            card.setVendor(CardVendor.AMEX);
            vendorFop.setCard(card);
        }
        Money money2 = new Money();
        money2.setCurrency("RUB");
        money2.setValue(BigDecimal.valueOf(this.fare + this.ruTaxAmount + this.yqTaxAmount + (this.penalty != null ? this.penalty.doubleValue() : 0.0)));
        vendorFop.setAmount(money2);
        block3: for (AirProductContractRelationData relation : AirProductHelper.getContractRelations((Product)product)) {
            switch (GeneralProductHelper.getContractType((EntityReference)relation.getDescription())) {
                case VENDOR: {
                    relation.getFops().add(vendorFop);
                    continue block3;
                }
            }
            ProductFop clonedFop = (ProductFop)XCloneHelper.clone((XCloneable)vendorFop, (boolean)true);
            clonedFop.setOperationDate(this.issueDate);
            clonedFop.setAgent(this.agentRef);
            relation.getFops().add(clonedFop);
        }
        EntityStorage.get().save(bfc, false);
        return product.getUid();
    }

    protected void createProfiles() throws Exception {
        EntityContainer ctr = new EntityContainer(SalesPoint.class);
        SalesPoint sp = (SalesPoint)ctr.getEntity();
        sp.setAgency(this.agencyReference);
        sp.setCode("sp001");
        sp.setFullName("Test Sales Point");
        sp.setShortName(sp.getFullName());
        EntityStorage.get().save(ctr, true);
        this.salesPointRef = ctr.toReference();
        this.blankOwner = this.bspReference;
        this.supplierRef = this.bspReference;
        EntityContainer sellFeeCtr = new EntityContainer(FeeProperties.class);
        FeeProperties prop = (FeeProperties)sellFeeCtr.getEntity();
        prop.setCategory((DictionaryReference)new CommissionCategoryReference("fee"));
        prop.setRoundingMode(RoundingMode.MATH);
        prop.setRoundingValue(RoundingValue.V_0_0_1);
        prop.setOperation(Operation.SELL);
        prop.getProductTypes().add(ProductType.AIR_TICKET);
        prop.getReturnCases().add(ReturnCase.EXCHANGE);
        prop.getReturnCases().add(ReturnCase.FORCED_EXCHANGE);
        prop.getReturnCases().add(ReturnCase.REFUND);
        prop.getReturnCases().add(ReturnCase.FORCED_REFUND);
        prop.getRouteTypes().add(RouteType.ONE_WAY);
        prop.getRouteTypes().add(RouteType.ROUND_TRIP);
        prop.setDisplayName("Sell fee");
        EntityStorage.get().save(sellFeeCtr, true);
        this.sellFeeRef = sellFeeCtr.toReference();
        EntityContainer refundFee = new EntityContainer(FeeProperties.class);
        prop = (FeeProperties)refundFee.getEntity();
        prop.setCategory((DictionaryReference)new CommissionCategoryReference("refundFee"));
        prop.setRoundingMode(RoundingMode.MATH);
        prop.setRoundingValue(RoundingValue.V_0_0_1);
        prop.setOperation(Operation.REFUND);
        prop.getProductTypes().add(ProductType.AIR_TICKET);
        prop.getReturnCases().add(ReturnCase.REFUND);
        prop.getReturnCases().add(ReturnCase.FORCED_REFUND);
        prop.getRouteTypes().add(RouteType.ONE_WAY);
        prop.getRouteTypes().add(RouteType.ROUND_TRIP);
        prop.setDisplayName("refund fee");
        EntityStorage.get().save(refundFee, true);
        this.refundFeeRef = refundFee.toReference();
        EntityContainer commission = new EntityContainer(CommissionProperties.class);
        prop = (CommissionProperties)commission.getEntity();
        prop.setCategory((DictionaryReference)new CommissionCategoryReference("commission"));
        prop.setRoundingMode(RoundingMode.MATH);
        prop.setRoundingValue(RoundingValue.V_0_0_1);
        prop.setDisplayName("commission");
        EntityStorage.get().save(commission, true);
        this.commissionRef = commission.toReference();
        this.supplierContractRef = this.createContract((EntityReference<Organization>)this.bspReference, (EntityReference<Organization>)this.agencyReference, ContractType.VENDOR, "SUPPLIER-01", this.commissionRef);
        this.subagentContractRef = this.createContract((EntityReference<Organization>)this.agencyReference, (EntityReference<Organization>)this.subagencyReference, ContractType.SUBAGENCY, "SUBAGENCY-01", this.commissionRef);
        this.clientContractRef = this.createContract((EntityReference<Organization>)this.subagencyReference, (EntityReference<Organization>)this.clientReference, ContractType.CLIENT, "CLIENT-01", this.sellFeeRef, this.refundFeeRef);
    }

    private EntityReference<Contract> createContract(EntityReference<Organization> supplier, EntityReference<Organization> customer, ContractType contractType, String contractNumber, EntityReference<?> ... commissions) {
        EntityContainer cc = new EntityContainer(Contract.class);
        Contract contract = (Contract)cc.getEntity();
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(this.issueDate);
        cldr.add(2, -6);
        ContractCustomerInfo info = new ContractCustomerInfo();
        contract.getCustomers().add(info);
        info.setIssueDate(cldr.getTime());
        info.setStartDate(cldr.getTime());
        cldr.add(2, 12);
        info.setEndDate(cldr.getTime());
        contract.setContractType(contractType);
        contract.setSupplier(supplier);
        info.setCustomer(customer);
        if (contractType == ContractType.VENDOR) {
            contract.setVendor(this.bspReference);
        }
        info.setNumber(contractNumber);
        RuleSet rules = new RuleSet();
        for (EntityReference<?> item : commissions) {
            RuleSettings rs = new RuleSettings();
            rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
            rs.setName(item.getCaption());
            RuleResult res = new RuleResult();
            res.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
            RuleResultValue value = new RuleResultValue();
            value.setCurrencyCode("%");
            value.setTarget(item);
            value.setValue(10.0);
            res.setValue((Object)value);
            rs.getResults().add(res);
            rules.getRules().add(rs);
        }
        contract.setRuleSet(rules);
        EntityStorage.get().save(cc, true);
        return cc.toReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BinaryData getJasperTemplate(String url) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(url);){
            IoUtil.copyStream((InputStream)is, (OutputStream)baos, (int)256);
        }
        BinaryData data = new BinaryData();
        data.setContentType(ContentType.JASPERDESIGN);
        data.setData(baos.toByteArray());
        return data;
    }

    protected byte[] compileJasperTemplate(byte[] content) throws Exception {
        JasperReport report = JasperUtil.getReport((byte[])content);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(report);
        oos.flush();
        oos.close();
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <P extends BaseTemplateReportParameters> File createReport(P parameters, ReportPrepareHandler prepareHandler, String fileName, ContentType contentType) throws Exception {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("key-report-params", parameters);
        prepareHandler.prepareData(context);
        for (Message message : (List)context.get("key-messages")) {
            if (message.getType() != MessageType.ERROR) continue;
            throw new Exception("report has error " + message.getMessage());
        }
        EntityContainer ctr = (EntityContainer)context.get("KEY_REPORT_DOCUMENT");
        EntityStorage.get().save(ctr, false);
        byte[] content = ((BaseSingleFileTemplateReportDocument)ctr.getEntity()).getFile().getContent();
        if (((BaseSingleFileTemplateReportDocument)ctr.getEntity()).getFile().getContentType() == ContentType.JASPERPRINT) {
            if (contentType == ContentType.EXCEL) {
                content = JasperUtil.convertToExcel((byte[])content);
            } else if (contentType == ContentType.PDF) {
                content = JasperUtil.convertToPdf((byte[])content);
            }
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(content);
        File reportFile = new File("./test/sales-reports/" + fileName);
        try (FileOutputStream fos = new FileOutputStream(reportFile);){
            IoUtil.copyStream((InputStream)bais, (OutputStream)fos, (int)256);
        }
        return reportFile;
    }

    protected RequestedParameterValue createParameter(String key, Object value) {
        RequestedParameterValue result = new RequestedParameterValue();
        result.setKey(key);
        result.setValue(value);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportData(String fileName) throws Exception {
        ItemExportSettings root = new ItemExportSettings();
        root.setGroup(true);
        root.setObjectId("root");
        root.setExportType(ExportType.NONE);
        ItemExportSettings dicts = new ItemExportSettings();
        dicts.setGroup(true);
        dicts.setObjectId("dict");
        dicts.setExportType(ExportType.INHERITED);
        dicts.setParent(root);
        root.getChildren().add(dicts);
        dicts.getChildren().add(this.createDictionarySettings(dicts, CommissionCategory.class));
        dicts.getChildren().add(this.createDictionarySettings(dicts, Preference.class));
        dicts.getChildren().add(this.createDictionarySettings(dicts, BlankType.class));
        ItemExportSettings entities = new ItemExportSettings();
        entities.setGroup(true);
        entities.setObjectId("entities");
        entities.setExportType(ExportType.INHERITED);
        entities.setParent(root);
        root.getChildren().add(entities);
        entities.getChildren().add(this.createEntitySettings(entities, Person.class));
        entities.getChildren().add(this.createEntitySettings(entities, CommissionProperties.class));
        entities.getChildren().add(this.createEntitySettings(entities, FeeProperties.class));
        entities.getChildren().add(this.createEntitySettings(entities, PaymentFeeProperties.class));
        entities.getChildren().add(this.createEntitySettings(entities, AllProductsTemplateReportDescription.class));
        entities.getChildren().add(this.createEntitySettings(entities, AllProductsTemplateReportDocument.class));
        entities.getChildren().add(this.createEntitySettings(entities, AirTicketsTemplateReportDescription.class));
        entities.getChildren().add(this.createEntitySettings(entities, AirTicketsTemplateReportDocument.class));
        entities.getChildren().add(this.createEntitySettings(entities, IndexBasedTemplateReportDescription.class));
        entities.getChildren().add(this.createEntitySettings(entities, IndexBasedTemplateReportDocument.class));
        entities.getChildren().add(this.createEntitySettings(entities, Contract.class));
        entities.getChildren().add(this.createEntitySettings(entities, Organization.class));
        entities.getChildren().add(this.createEntitySettings(entities, BookingFile.class));
        entities.getChildren().add(this.createEntitySettings(entities, SalesPoint.class));
        Object result = new ExportObjectsTask().execute(new AsyncServerTask.Callback(){

            public void updateProgress(byte progress, String message) {
                TemplateReportTestBase.this.log.info(String.format("progress : %s, message : %s", progress, message));
            }

            public void addMessage(Message message) {
                TemplateReportTestBase.this.log.info(String.format("%s : %s", message.getType(), message.getMessage()));
            }
        }, Collections.singletonList(root));
        ExportedObjectsBundle bundle = new ExportedObjectsBundle();
        bundle.setExportSettings(root);
        bundle.getExportedItems().addAll((Collection)((Map)result).values().iterator().next());
        try (FileOutputStream fos = new FileOutputStream(new File(String.format("./temp/%s", fileName)));){
            XUtil.serialize((XSerializable)bundle, (OutputStream)fos);
        }
    }

    private <E extends BaseEntity> ItemExportSettings createEntitySettings(ItemExportSettings entities, Class<E> cls) {
        ItemExportSettings settings = new ItemExportSettings();
        settings.setObjectId(cls.getName());
        settings.setItemType(ItemType.ENTITY);
        settings.setExportType(ExportType.ALL);
        settings.setParent(entities);
        return settings;
    }

    private <D extends BaseDictionary> ItemExportSettings createDictionarySettings(ItemExportSettings dicts, Class<D> cls) {
        ItemExportSettings settings = new ItemExportSettings();
        settings.setObjectId(cls.getName());
        settings.setExportType(ExportType.ALL);
        settings.setItemType(ItemType.DICTIONARY);
        settings.setParent(dicts);
        return settings;
    }

    protected BinaryData getTemplate(String relativePath, ContentType type) throws Exception {
        File file = new File("plugins/com.gridnine.xtrip.server.reports/config/server-reports-setup/entity/templates", relativePath);
        byte[] content = IoUtil.readFileToByteArray((File)file);
        BinaryData result = new BinaryData();
        result.setContentType(type);
        result.setData(content);
        return result;
    }
}

