/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.render.vv;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlank;
import com.gridnine.xtrip.common.model.stockcontrol.UsageStatus;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.vv.VvRegistryRender;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.reports.prepare.PrepareHandlersRegistry;
import com.gridnine.xtrip.server.reports.prepare.salesreports.vv.VvSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.stockcontrol.vv.VvStockControlReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.prepare.VvReportPrepareBaseTest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.junit.Test;

public class VvRegistryReportRenderTest
extends VvReportPrepareBaseTest {
    private final double[] equivTariffs = new double[]{1200.0, 3560.0, 9030.0, 2400.0, 3400.0, 7600.0, 9100.0, 10000.0, 12000.0, 1500.0};
    protected Date issueDate;
    protected Map<String, Object> data = new HashMap<String, Object>();
    protected Map<String, Date> dates = new HashMap<String, Date>();
    Date startDate;
    Date endDate;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        if (!Environment.isPublished(PrepareHandlersRegistry.class)) {
            PrepareHandlersRegistry prepareRegistry = new PrepareHandlersRegistry();
            Environment.publish((Object)prepareRegistry);
        }
        ((PrepareHandlersRegistry)Environment.getPublished(PrepareHandlersRegistry.class)).register(new VvStockControlReportPrepareHandler());
    }

    @Test
    public void testRegisterRender() throws Exception {
        this.init();
        this.createBookingFiles();
        this.createBlanks();
        this.prepareReport(this.data);
        this.render(this.data);
    }

    protected void createBookingFiles() throws Exception {
        for (int i = 0; i < 10; ++i) {
            EntityContainer bfc = new EntityContainer(BookingFile.class);
            BookingFile bookingFile = (BookingFile)bfc.getEntity();
            String user = LogicalStorage.get().getUser();
            bfc.setCreatedBy(user);
            bfc.setModifiedBy(user);
            Reservation reservation = new Reservation();
            reservation.setBookingFile(bookingFile);
            bookingFile.getReservations().add(reservation);
            this.addProduct(reservation, bookingFile, "VV", "RUB", this.equivTariffs[i], this.generateTicketNumber(i));
            EntityStorage.get().save(bfc, true);
        }
        EntityContainer bfc = new EntityContainer(BookingFile.class);
        BookingFile bookingFile = (BookingFile)bfc.getEntity();
        String user = LogicalStorage.get().getUser();
        bfc.setCreatedBy(user);
        bfc.setModifiedBy(user);
        Reservation reservation = new Reservation();
        reservation.setBookingFile(bookingFile);
        bookingFile.getReservations().add(reservation);
        EntityStorage.get().save(bfc, true);
    }

    protected Product addProduct(Reservation reservation, BookingFile bookingFile, String airlineCode, String currencyCode, double equivalentTariff, String ticketNumber) throws Exception {
        Product product = new Product();
        product.setReservation(reservation);
        reservation.getProducts().add(product);
        product.setProductCategory(ProductCategory.AIR);
        product.setBlankOwnerRef(this.findBlankOwnerByCode(airlineCode));
        product.setBlankOwnerNumber("870");
        product.setStatus(ProductStatus.SELL);
        product.setCarrier((DictionaryReference)new AirlineReference(airlineCode));
        product.setCarrierNumber(airlineCode);
        product.setBlankType((DictionaryReference)new BlankTypeReference("870 24"));
        bookingFile.setAgency(new EntityReference(this.ac));
        Segment segment = new Segment();
        segment.setStartDate(Calendar.getInstance().getTime());
        segment.setAirline((DictionaryReference)new AirlineReference(airlineCode));
        segment.setDepartureLocation((DictionaryReference)new GeoLocationReference("MSC"));
        segment.setArriveLocation((DictionaryReference)new GeoLocationReference("VIE"));
        segment.setFareBasis("farebasis");
        SegmentTariff sppPsgr = new SegmentTariff();
        sppPsgr.getSegments().add(segment);
        Money money = new Money();
        money.setValue(BigDecimal.valueOf(0.5 * equivalentTariff));
        money.setCurrency(currencyCode);
        product.getSegmentTariffs().add(sppPsgr);
        segment = new Segment();
        segment.setStartDate(Calendar.getInstance().getTime());
        segment.setAirline((DictionaryReference)new AirlineReference(airlineCode));
        segment.setDepartureLocation((DictionaryReference)new GeoLocationReference("VIE"));
        segment.setArriveLocation((DictionaryReference)new GeoLocationReference("MSC"));
        segment.setFareBasis("farebasis");
        sppPsgr = new SegmentTariff();
        sppPsgr.getSegments().add(segment);
        money = new Money();
        money.setValue(BigDecimal.valueOf(0.5 * equivalentTariff));
        money.setCurrency(currencyCode);
        product.getSegmentTariffs().add(sppPsgr);
        Money money2 = new Money();
        money2.setValue(BigDecimal.valueOf(equivalentTariff));
        money2.setCurrency(currencyCode);
        AirProductHelper.setBaseFare((Product)product, (Money)money2);
        Tax tax = new Tax();
        tax.setCode("RU");
        tax.setAmount(SystemHelper.getMoney((double)36.0, (String)"RUB"));
        tax.setEquivalentAmount(BigDecimal.valueOf(36L));
        product.getTaxes().add(tax);
        AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)BigDecimal.valueOf(equivalentTariff));
        product.setIssueDate(this.issueDate);
        ProductFop fop = new ProductFop();
        fop.setType(PaymentType.CASH);
        Money money3 = new Money();
        money3.setValue(BigDecimal.valueOf(equivalentTariff + 36.0));
        money3.setCurrency(currencyCode);
        fop.setAmount(money3);
        AirProductHelper.getVendorContractRelation((Product)product).getFops().add(fop);
        product.setSystemNumber(ticketNumber);
        return product;
    }

    private String generateTicketNumber(int number) {
        return String.format("%1$d", 2405822000L + (long)number);
    }

    protected void prepareReport(Map<String, Object> data) throws Exception {
        VvSalesReportPrepareHandler handler = new VvSalesReportPrepareHandler();
        ReportParameters params = new ReportParameters();
        params.setPeriodBegin(this.startDate);
        params.setPeriodEnd(this.endDate);
        params.setAgency(new EntityReference(this.ac));
        params.setBlankOwner((EntityReference)ProfileDao.getProfileReferenceByCode((String)"VV", OrganizationIndex.class).get(0));
        data.put("key-report-params", params);
        handler.prepareData(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Map<String, Object> data) throws Exception {
        TestVvRegistryRender registryHandler = new TestVvRegistryRender();
        EntityContainer repDoc = registryHandler.renderReport(data);
        ReportFile repFile = (ReportFile)((ReportDocument)repDoc.getEntity()).getFiles().get(0);
        try (FileOutputStream fileOut = new FileOutputStream(this.buildOutputFileName("VvReportTest.xls"));){
            ByteArrayInputStream is = new ByteArrayInputStream(repFile.getContent());
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            wb.write((OutputStream)fileOut);
        }
    }

    private File buildOutputFileName(String fileName) throws IOException {
        File result = new File("./test/sales-reports/");
        if (!result.exists() && !result.mkdirs()) {
            throw new IOException("can't make directory " + result.getCanonicalPath());
        }
        return new File(result, fileName);
    }

    private void init() throws Exception {
        this.ac = this.createAgency();
        this.airlineRef = this.createAirlineVV();
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss");
        this.dates.put("startReg", df.parse("20.02.2009 14:45:00"));
        this.dates.put("startOper", df.parse("02.03.2009 09:17:00"));
        this.dates.put("inReg", df.parse("01.03.2009 17:10:00"));
        this.dates.put("inOper", df.parse("12.03.2009 11:27:00"));
        this.dates.put("outReg", df.parse("20.02.2009 14:45:00"));
        this.dates.put("outOper", df.parse("09.03.2009 08:29:00"));
        this.dates.put("endReg", df.parse("01.03.2009 17:10:00"));
        this.dates.put("endOper", df.parse("11.03.2009 10:14:00"));
        this.startDate = df.parse("01.03.2009 00:00:00");
        this.endDate = df.parse("10.03.2009 23:59:59");
        this.issueDate = df.parse("07.03.2009 08:17:56");
    }

    private void createBlanks() throws Exception {
        EntityContainer bc = null;
        BlankType blankType24 = null;
        Set result = DictHelper.getDictionaryItemsByCode(BlankType.class, (String)"870 24");
        if (result.iterator().hasNext()) {
            blankType24 = (BlankType)result.iterator().next();
        }
        for (int i = 20; i < 55; ++i) {
            bc = new EntityContainer(StockBlank.class);
            StockBlank blank = (StockBlank)bc.getEntity();
            blank.setNumber(this.generateNumber(i));
            blank.setOwner(this.vvReference);
            blank.setSupplier(this.vvReference);
            blank.setStockHolder(this.ac.toReference());
            blank.setUsageStatus(UsageStatus.NEW);
            if (i <= 25) {
                blank.setRegistrationDate(this.dates.get("startReg"));
                blank.setOperationDate(this.dates.get("startOper"));
            } else if (i > 25 && i <= 35) {
                blank.setRegistrationDate(this.dates.get("inReg"));
                blank.setOperationDate(this.dates.get("inOper"));
            } else if (i > 35 && i <= 45) {
                blank.setRegistrationDate(this.dates.get("outReg"));
                blank.setOperationDate(this.dates.get("outOper"));
                blank.setUsageStatus(UsageStatus.SELL);
            } else {
                blank.setRegistrationDate(this.dates.get("endReg"));
                blank.setOperationDate(this.dates.get("endOper"));
            }
            blank.setTariffType(TariffType.REGULAR);
            blank.setType((DictionaryReference)blankType24.toReference());
            this.save(bc);
        }
    }

    private String generateNumber(int number) {
        String result = "";
        result = String.format("%1$010d", number);
        return result;
    }

    class TestVvRegistryRender
    extends VvRegistryRender<SuTicket> {
        TestVvRegistryRender() {
        }

        protected File getTemplateFile() throws IOException {
            File result = new File("plugins/com.gridnine.xtrip.common.reports/templates/salesreports/" + this.getTemplateFileName());
            if (!result.exists()) {
                throw new IOException("Template " + result.getCanonicalPath() + " was not found");
            }
            return result;
        }
    }
}

