/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.stockcontrol.prepare.su;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlank;
import com.gridnine.xtrip.common.model.stockcontrol.UsageStatus;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.reports.prepare.stockcontrol.su.SuStockControlReportPrepareHandler;
import com.gridnine.xtrip.server.reports.stockcontrol.prepare.PrepareStockControlReportTestBase;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class SuStockOverviewReportTest
extends PrepareStockControlReportTestBase {
    @Test
    public void testSuStockOverviewReportPrepare() throws Exception {
        EntityContainer<Organization> ac = this.createAgency();
        AirlineReference airlineRef = this.createAirlineSU();
        EntityContainer bc = null;
        for (int i = 0; i < 10; ++i) {
            bc = new EntityContainer(StockBlank.class);
            StockBlank blank = (StockBlank)bc.getEntity();
            blank.setOwner(this.suReference);
            blank.setSupplier(this.suReference);
            blank.setStockHolder(ac.toReference());
            blank.setRegistrationDate(new Date());
            blank.setOperationDate(null);
            blank.setUsageStatus(UsageStatus.NEW);
            blank.setTariffType(TariffType.REGULAR);
            this.save(bc);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        ReportParameters params = new ReportParameters();
        data.put("key-report-params", params);
        params.setAgency(ac.toReference());
        params.setSupplier(this.suReference);
        params.setBlankOwner(((EntityContainer)ProfileDao.getBlankOwnersByAirline((DictionaryReference)airlineRef).get(0)).toReference());
        Calendar cl = Calendar.getInstance();
        Calendar cl2 = Calendar.getInstance();
        cl.setTime(new Date());
        cl2.setTime(new Date());
        cl.add(2, 1);
        cl2.add(2, 2);
        params.setPeriodBegin(cl.getTime());
        params.setPeriodEnd(cl2.getTime());
        SuStockControlReportPrepareHandler handler = new SuStockControlReportPrepareHandler();
        handler.prepareData(data);
        Set blanks = (Set)data.get("key-batch-data-list");
        Assert.assertEquals((long)10L, (long)blanks.size());
    }

    private AirlineReference createAirlineSU() throws Exception {
        return DictHelper.findAirlineByAnyCode((String)"SU").toReference();
    }

    private EntityContainer<Organization> createAgency() throws Exception {
        EntityContainer result = new EntityContainer(Organization.class);
        Organization agency = (Organization)result.getEntity();
        agency.setActive(true);
        L10nStringHelper.setValue((L10nString)agency.getShortName(), (String)"ABC", (Locale)Locale.ENGLISH);
        L10nStringHelper.setValue((L10nString)agency.getFullName(), (String)"ABC agency", (Locale)Locale.ENGLISH);
        agency.setCode("001");
        SystemHelper.setMetadataValue((Collection)agency.getMetadata(), (MetadataKey)MetadataKey.KEY_SU_AGENCY_CODE, (Object)"0001");
        this.save(result);
        return result;
    }

    private void save(EntityContainer<?> ec) throws Exception {
        EntityStorage es = EntityStorage.get();
        String user = LogicalStorage.get().getUser();
        ec.setCreated(new Date());
        ec.setModified(new Date());
        ec.setCreatedBy(user);
        ec.setModifiedBy(user);
        es.save(ec, false);
    }
}

