/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.stockcontrol.prepare.vv;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlank;
import com.gridnine.xtrip.common.model.stockcontrol.UsageStatus;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.reports.prepare.stockcontrol.vv.VvStockControlReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.prepare.VvReportPrepareBaseTest;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class VvStockOverviewPrepareTest
extends VvReportPrepareBaseTest {
    @Test
    public void testStockOverview() throws Exception {
        this.init();
        this.createBlanks();
        this.testBlankExistence();
    }

    private void init() throws Exception {
        this.ac = this.createAgency();
        this.airlineRef = this.createAirlineVV();
    }

    private void createBlanks() throws Exception {
        EntityContainer bc = null;
        for (int i = 0; i < 10; ++i) {
            bc = new EntityContainer(StockBlank.class);
            StockBlank blank = (StockBlank)bc.getEntity();
            blank.setOwner(this.vvReference);
            blank.setSupplier(this.vvReference);
            blank.setStockHolder(this.ac.toReference());
            blank.setRegistrationDate(new Date());
            blank.setOperationDate(null);
            blank.setUsageStatus(UsageStatus.NEW);
            blank.setTariffType(TariffType.REGULAR);
            this.save(bc);
        }
    }

    private void testBlankExistence() throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ReportParameters params = new ReportParameters();
        data.put("key-report-params", params);
        params.setAgency(this.ac.toReference());
        params.setSupplier(this.vvReference);
        params.setBlankOwner(((EntityContainer)ProfileDao.getBlankOwnersByAirline((DictionaryReference)this.airlineRef).get(0)).toReference());
        Calendar cl = Calendar.getInstance();
        Calendar cl2 = Calendar.getInstance();
        cl.setTime(new Date());
        cl2.setTime(new Date());
        cl.add(2, 1);
        cl2.add(2, 2);
        params.setPeriodBegin(cl.getTime());
        params.setPeriodEnd(cl2.getTime());
        VvStockControlReportPrepareHandler handler = new VvStockControlReportPrepareHandler();
        handler.prepareData(data);
        Set blanks = (Set)data.get("key-batch-data-list");
        Assert.assertEquals((long)10L, (long)blanks.size());
    }
}

