/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.stockcontrol.render;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.excel.test.ExcelTestUtils;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlank;
import com.gridnine.xtrip.common.model.stockcontrol.UsageStatus;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.stockcontrol.BaseStockcontrolOverviewReportRender;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.ReportsTestBase;
import com.gridnine.xtrip.server.reports.prepare.stockcontrol.BaseStockControlReportPrepareHandler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.junit.Assert;
import org.junit.Test;

public abstract class RenderStockControlReportTestBase
extends ReportsTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReport() throws Exception {
        this.createContract();
        EntityContainer<Organization> agencyContainer = this.getAgency();
        EntityContainer<Organization> blankOwnerContainer = this.getBlankOwner();
        EntityReference agencyReference = agencyContainer.toReference();
        EntityReference blankOwnerReference = blankOwnerContainer.toReference();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss");
        HashMap<String, Date> dates = new HashMap<String, Date>();
        dates.put("startReg", dateFormat.parse("20.02.2009 14:45:00"));
        dates.put("startOper", dateFormat.parse("02.03.2009 09:17:00"));
        dates.put("inReg", dateFormat.parse("01.03.2009 17:10:00"));
        dates.put("inOper", dateFormat.parse("12.03.2009 11:27:00"));
        dates.put("outReg", dateFormat.parse("20.02.2009 14:45:00"));
        dates.put("outOper", dateFormat.parse("09.03.2009 08:29:00"));
        dates.put("endReg", dateFormat.parse("01.03.2009 17:10:00"));
        dates.put("endOper", dateFormat.parse("11.03.2009 10:14:00"));
        Date startDate = dateFormat.parse("01.03.2009 00:00:00");
        Date endDate = dateFormat.parse("10.03.2009 23:59:59");
        BlankType blankType = this.getBlankType();
        Assert.assertNotNull((Object)blankType);
        for (int i = 20; i < 55; ++i) {
            EntityContainer stockBlankContainer = new EntityContainer(StockBlank.class);
            StockBlank stockBlank = (StockBlank)stockBlankContainer.getEntity();
            stockBlank.setNumber(String.format("%010d", i));
            stockBlank.setStockHolder(agencyReference);
            stockBlank.setOwner(blankOwnerReference);
            stockBlank.setSupplier(blankOwnerReference);
            stockBlank.setUsageStatus(UsageStatus.NEW);
            if (i <= 25) {
                stockBlank.setRegistrationDate((Date)dates.get("startReg"));
                stockBlank.setOperationDate((Date)dates.get("startOper"));
            } else if (i > 25 && i <= 35) {
                stockBlank.setRegistrationDate((Date)dates.get("inReg"));
                stockBlank.setOperationDate((Date)dates.get("inOper"));
            } else if (i > 35 && i <= 45) {
                stockBlank.setRegistrationDate((Date)dates.get("outReg"));
                stockBlank.setOperationDate((Date)dates.get("outOper"));
                stockBlank.setUsageStatus(UsageStatus.SELL);
            } else {
                stockBlank.setRegistrationDate((Date)dates.get("endReg"));
                stockBlank.setOperationDate((Date)dates.get("endOper"));
            }
            stockBlank.setTariffType(TariffType.REGULAR);
            stockBlank.setType((DictionaryReference)blankType.toReference());
            this.save(stockBlankContainer);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        ReportParameters parameters = new ReportParameters();
        data.put("key-report-params", parameters);
        parameters.setPeriodBegin(startDate);
        parameters.setPeriodEnd(endDate);
        parameters.setAgency(agencyReference);
        parameters.setBlankOwner(blankOwnerReference);
        parameters.setSupplier(blankOwnerReference);
        BaseStockControlReportPrepareHandler reportPrepareHandler = this.getReportPrepareHandler();
        reportPrepareHandler.prepareData(data);
        Set blanks = (Set)data.get("key-batch-data-list");
        Assert.assertEquals((long)35L, (long)blanks.size());
        BaseStockcontrolOverviewReportRender reportRenderHandler = this.getReportRenderHandler();
        EntityContainer reportDocument = reportRenderHandler.renderReport(data);
        ReportFile reportFile = (ReportFile)((ReportDocument)reportDocument.getEntity()).getFiles().get(0);
        File file = this.buildOutputFileName(this.getReportFileName());
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            HSSFWorkbook workbook = new HSSFWorkbook(new POIFSFileSystem((InputStream)new ByteArrayInputStream(reportFile.getContent())));
            workbook.write((OutputStream)fileOutputStream);
        }
        String modelFileName = this.getModelFileName();
        if (!TextUtil.isBlank((String)modelFileName)) {
            String compare;
            Assert.assertTrue((String)compare, ((compare = ExcelTestUtils.compareWorkbooks((File)IoUtil.url2file((URL)this.getLoaderClass().getResource(modelFileName)), (File)file)) == null ? 1 : 0) != 0);
        }
    }

    private void createContract() throws Exception {
        EntityContainer contractContainer = new EntityContainer(Contract.class);
        Contract contract = (Contract)contractContainer.getEntity();
        EntityContainer<Organization> agencyContainer = this.getAgency();
        EntityContainer<Organization> blankOwnerContainer = this.getBlankOwner();
        EntityReference agencyReference = agencyContainer.toReference();
        EntityReference blankOwnerReference = blankOwnerContainer.toReference();
        contract.setContractType(ContractType.VENDOR);
        contract.setVendor(blankOwnerReference);
        contract.setSupplier(blankOwnerReference);
        ContractCustomerInfo info = new ContractCustomerInfo();
        contract.getCustomers().add(info);
        info.setNumber("0000000001");
        info.setCustomer(agencyReference);
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        Date issueDate = dateFormat.parse("01.01.2011");
        info.setIssueDate(issueDate);
        this.save(contractContainer);
    }

    protected BlankType getBlankType() {
        Set blankTypes = DictHelper.getDictionaryItemsByCode(BlankType.class, (String)this.getBlankTypeCode());
        return blankTypes.iterator().hasNext() ? (BlankType)blankTypes.iterator().next() : null;
    }

    protected File buildOutputFileName(String fileName) throws IOException {
        File directory = new File("./test/stockcontrol-reports/");
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("can't make directory " + directory.getCanonicalPath());
        }
        return new File(directory, fileName);
    }

    protected Class<? extends RenderStockControlReportTestBase> getLoaderClass() {
        return ((Object)((Object)this)).getClass();
    }

    protected abstract EntityContainer<Organization> getAgency() throws Exception;

    protected abstract EntityContainer<Organization> getBlankOwner() throws Exception;

    protected abstract String getBlankTypeCode();

    protected abstract String getReportFileName();

    protected abstract String getModelFileName();

    protected abstract BaseStockControlReportPrepareHandler getReportPrepareHandler();

    protected abstract BaseStockcontrolOverviewReportRender getReportRenderHandler();
}

