/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.stockcontrol.render.hy;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ManagerType;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Manager;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlank;
import com.gridnine.xtrip.common.model.stockcontrol.UsageStatus;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.stockcontrol.hy.HyStockControlReportOverviewRenderHandler;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import com.gridnine.xtrip.server.reports.prepare.stockcontrol.hy.HyStockControlReportPrepareHandler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.junit.Assert;
import org.junit.Test;

public class HyStockControlReportRenderTest
extends ModelTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHyStockcontrolReportRender() throws Exception {
        EntityReference hyReference = new EntityReference("HY_container", Organization.class, "\u041d\u0410\u041a \"\u0423\u0437\u0431\u0435\u043a\u0438\u0441\u0442\u043e\u043d \u0425\u0430\u0432\u043e \u0419\u0443\u043b\u043b\u0430\u0440\u0438\"");
        EntityContainer<Organization> ac = this.createAgency();
        AirlineReference airlineRef = this.createAirlineHY();
        List<BlankType> blankTypes = this.createBlanks((EntityReference<Organization>)hyReference);
        EntityContainer bc = null;
        StockBlank stockBlank = null;
        int blankBatchCounter = 0;
        int blankCounter = 0;
        int totalBlankCounter = 0;
        for (BlankType blankType : blankTypes) {
            switch (blankType.getProductCategory()) {
                case AIR: {
                    blankBatchCounter = 2;
                    blankCounter = 10;
                    break;
                }
                case EXCESS_BAGAGE: {
                    blankBatchCounter = 3;
                    blankCounter = 20;
                    break;
                }
                case MCO: {
                    blankBatchCounter = 4;
                    blankCounter = 30;
                    break;
                }
            }
            totalBlankCounter += blankBatchCounter * blankCounter;
            for (int j = 0; j < blankBatchCounter; ++j) {
                for (int i = 0; i < blankCounter; ++i) {
                    bc = new EntityContainer(StockBlank.class);
                    stockBlank = (StockBlank)bc.getEntity();
                    stockBlank.setNumber(blankType.getName() + "00000000" + j + (i < 10 ? "0" : "") + String.valueOf(i));
                    stockBlank.setOwner(hyReference);
                    stockBlank.setSupplier(hyReference);
                    stockBlank.setStockHolder(ac.toReference());
                    stockBlank.setRegistrationDate(new Date());
                    stockBlank.setOperationDate(null);
                    stockBlank.setUsageStatus(UsageStatus.NEW);
                    stockBlank.setTariffType(TariffType.REGULAR);
                    stockBlank.setType((DictionaryReference)blankType.toReference());
                    this.saveEntityContainer(bc);
                }
            }
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        ReportParameters params = new ReportParameters();
        Calendar cl = Calendar.getInstance();
        Calendar cl2 = Calendar.getInstance();
        cl.setTime(new Date());
        cl2.setTime(new Date());
        cl.add(2, 1);
        cl2.add(2, 2);
        params.setPeriodBegin(cl.getTime());
        params.setPeriodEnd(cl2.getTime());
        data.put("key-report-params", params);
        params.setAgency(ac.toReference());
        params.setSupplier(hyReference);
        params.setBlankOwner(((EntityContainer)ProfileDao.getBlankOwnersByAirline((DictionaryReference)airlineRef).get(0)).toReference());
        HyStockControlReportPrepareHandler handler = new HyStockControlReportPrepareHandler();
        handler.prepareData(data);
        Set blanks = (Set)data.get("key-batch-data-list");
        Assert.assertEquals((long)totalBlankCounter, (long)blanks.size());
        TestHyStockControlReportOverviewRender render = new TestHyStockControlReportOverviewRender();
        EntityContainer repDoc = render.renderReport(data);
        ReportFile repFile = (ReportFile)((ReportDocument)repDoc.getEntity()).getFiles().get(0);
        try (FileOutputStream fileOut = new FileOutputStream(this.buildOutputFileName("HyStockOverview.xls"));){
            ByteArrayInputStream is = new ByteArrayInputStream(repFile.getContent());
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            wb.write((OutputStream)fileOut);
        }
    }

    private File buildOutputFileName(String fileName) throws IOException {
        File result = new File("./test/stockcontrol-reports/");
        if (!result.exists() && !result.mkdirs()) {
            throw new IOException("can't make directory " + result.getCanonicalPath());
        }
        return new File(result, fileName);
    }

    private AirlineReference createAirlineHY() throws Exception {
        return DictHelper.findAirlineByAnyCode((String)"HY").toReference();
    }

    private EntityContainer<Organization> createAgency() throws Exception {
        EntityContainer result = new EntityContainer(Organization.class);
        Organization agency = (Organization)result.getEntity();
        agency.setActive(true);
        L10nStringHelper.setValue((L10nString)agency.getShortName(), (String)"ABC", (Locale)Locale.ENGLISH);
        L10nStringHelper.setValue((L10nString)agency.getFullName(), (String)"ABC agency", (Locale)Locale.ENGLISH);
        agency.setCode("001");
        SystemHelper.setMetadataValue((Collection)agency.getMetadata(), (MetadataKey)MetadataKey.KEY_HY_AGENCY_CODE, (Object)"0001");
        Address address = new Address();
        address.setAddressType(AddressType.CONTACT);
        L10nStringHelper.setValue((L10nString)address.getAddress(), (String)"city street building", (Locale)Locale.ENGLISH);
        agency.getAddresses().add(address);
        Manager man1 = new Manager();
        man1.setName("Chief Accountant");
        man1.setType(ManagerType.CHIEF_ACCOUNTANT);
        agency.getManagers().add(man1);
        Manager man2 = new Manager();
        man2.setName("Director");
        man2.setType(ManagerType.DIRECTOR);
        agency.getManagers().add(man2);
        Manager man3 = new Manager();
        man3.setName("Travel Manager");
        man3.setType(ManagerType.TRAVEL_MANAGER);
        agency.getManagers().add(man3);
        this.saveEntityContainer(result);
        return result;
    }

    private List<BlankType> createBlanks(EntityReference<Organization> hyReference) throws Exception {
        ArrayList<BlankType> blankTypes = new ArrayList<BlankType>();
        EntityContainer btc = new EntityContainer(BlankType.class);
        BlankType airBlankType = (BlankType)btc.getEntity();
        airBlankType.setName("44");
        airBlankType.setCode("250 44");
        airBlankType.setCouponsCount(1);
        airBlankType.setProductCategory(ProductCategory.AIR);
        airBlankType.setBlankOwner(hyReference);
        airBlankType.setBlankCategory(BlankCategory.PRINTED_NUMBER);
        blankTypes.add(airBlankType);
        this.updateDictionaryCache((BaseDictionary)airBlankType);
        btc = new EntityContainer(BlankType.class);
        airBlankType = (BlankType)btc.getEntity();
        airBlankType.setName("45");
        airBlankType.setCode("250 45");
        airBlankType.setCouponsCount(1);
        airBlankType.setProductCategory(ProductCategory.EXCESS_BAGAGE);
        airBlankType.setBlankOwner(hyReference);
        airBlankType.setBlankCategory(BlankCategory.PRINTED_NUMBER);
        blankTypes.add(airBlankType);
        this.updateDictionaryCache((BaseDictionary)airBlankType);
        btc = new EntityContainer(BlankType.class);
        airBlankType = (BlankType)btc.getEntity();
        airBlankType.setName("40");
        airBlankType.setCode("250 40");
        airBlankType.setCouponsCount(1);
        airBlankType.setProductCategory(ProductCategory.MCO);
        airBlankType.setBlankOwner(hyReference);
        airBlankType.setBlankCategory(BlankCategory.PRINTED_NUMBER);
        blankTypes.add(airBlankType);
        this.updateDictionaryCache((BaseDictionary)airBlankType);
        return blankTypes;
    }

    private void updateDictionaryCache(BaseDictionary baseDictionary) {
        DictionaryCache.get().put(baseDictionary);
    }

    private void saveEntityContainer(EntityContainer<?> ec) throws Exception {
        EntityStorage es = EntityStorage.get();
        String user = LogicalStorage.get().getUser();
        ec.setCreated(new Date());
        ec.setModified(new Date());
        ec.setCreatedBy(user);
        ec.setModifiedBy(user);
        es.save(ec, false);
    }

    class TestHyStockControlReportOverviewRender
    extends HyStockControlReportOverviewRenderHandler {
        TestHyStockControlReportOverviewRender() {
        }

        protected File getTemplateFile() throws IOException {
            File result = new File("plugins/com.gridnine.xtrip.common.reports/templates/stockcontrolreports/" + this.getTemplateFileName());
            if (!result.exists()) {
                throw new IOException("Template " + result.getCanonicalPath() + " was not found");
            }
            return result;
        }
    }
}

