/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.stockcontrol.render.su;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ManagerType;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Manager;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlank;
import com.gridnine.xtrip.common.model.stockcontrol.UsageStatus;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.stockcontrol.su.SuStockcontrolReportOverviewRenderHandler;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import com.gridnine.xtrip.server.reports.prepare.stockcontrol.su.SuStockControlReportPrepareHandler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.junit.Assert;
import org.junit.Test;

public class SuStockcontrolReportRenderTest
extends ModelTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuStockcontrolReportRender() throws Exception {
        StockBlank blank;
        int i;
        EntityReference suReference = new EntityReference("SU_container", Organization.class, "\u041e\u0410\u041e \"\u0410\u044d\u0440\u043e\u0444\u043b\u043e\u0442- \u0440\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0435 \u0430\u0432\u0438\u0430\u043b\u0438\u043d\u0438\u0438\"");
        EntityContainer<Organization> ac = this.createAgency();
        AirlineReference airlineRef = this.createAirlineSU();
        EntityContainer bc = null;
        BlankType blankType24 = null;
        BlankType blankType401 = null;
        EntityContainer entityBlankType = new EntityContainer(BlankType.class);
        BlankType blankTypeWithGeneratedNumber = (BlankType)entityBlankType.getEntity();
        blankTypeWithGeneratedNumber.setCode("555 \u0411\u041f\u0423");
        blankTypeWithGeneratedNumber.setName("\u0411\u041f\u0423");
        blankTypeWithGeneratedNumber.setCouponsCount(4);
        blankTypeWithGeneratedNumber.setBlankOwner(suReference);
        blankTypeWithGeneratedNumber.setProductCategory(ProductCategory.AIR);
        blankTypeWithGeneratedNumber.setBlankCategory(BlankCategory.GENERATED_NUMBER);
        this.save(entityBlankType);
        this.updateDictionaryCache((BaseDictionary)blankTypeWithGeneratedNumber);
        Set result = DictHelper.getDictionaryItemsByCode(BlankType.class, (String)"555 24");
        if (result.iterator().hasNext()) {
            blankType24 = (BlankType)result.iterator().next();
        }
        if ((result = DictHelper.getDictionaryItemsByCode(BlankType.class, (String)"555 401")).iterator().hasNext()) {
            blankType401 = (BlankType)result.iterator().next();
        }
        for (i = 0; i < 20; ++i) {
            bc = new EntityContainer(StockBlank.class);
            blank = (StockBlank)bc.getEntity();
            blank.setNumber("00000000" + String.valueOf(i));
            blank.setOwner(suReference);
            blank.setSupplier(suReference);
            blank.setStockHolder(ac.toReference());
            blank.setRegistrationDate(new Date());
            blank.setOperationDate(null);
            blank.setUsageStatus(UsageStatus.NEW);
            blank.setTariffType(TariffType.REGULAR);
            blank.setType((DictionaryReference)blankType24.toReference());
            this.save(bc);
        }
        for (i = 0; i < 20; ++i) {
            bc = new EntityContainer(StockBlank.class);
            blank = (StockBlank)bc.getEntity();
            blank.setNumber("00000001" + String.valueOf(i));
            blank.setOwner(suReference);
            blank.setSupplier(suReference);
            blank.setStockHolder(ac.toReference());
            blank.setRegistrationDate(new Date());
            blank.setOperationDate(null);
            blank.setUsageStatus(UsageStatus.NEW);
            blank.setTariffType(TariffType.REGULAR);
            blank.setType((DictionaryReference)blankType401.toReference());
            this.save(bc);
        }
        for (i = 0; i < 30; ++i) {
            bc = new EntityContainer(StockBlank.class);
            blank = (StockBlank)bc.getEntity();
            blank.setNumber("00000002" + String.valueOf(i));
            blank.setOwner(suReference);
            blank.setSupplier(suReference);
            blank.setStockHolder(ac.toReference());
            blank.setRegistrationDate(new Date());
            blank.setOperationDate(null);
            blank.setUsageStatus(UsageStatus.NEW);
            blank.setTariffType(TariffType.REGULAR);
            blank.setType((DictionaryReference)blankTypeWithGeneratedNumber.toReference());
            this.save(bc);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        ReportParameters params = new ReportParameters();
        Calendar cl = Calendar.getInstance();
        Calendar cl2 = Calendar.getInstance();
        cl.setTime(new Date());
        cl2.setTime(new Date());
        cl.add(2, 1);
        cl2.add(2, 2);
        params.setPeriodBegin(cl.getTime());
        params.setPeriodEnd(cl2.getTime());
        data.put("key-report-params", params);
        params.setAgency(ac.toReference());
        params.setSupplier(suReference);
        params.setBlankOwner(((EntityContainer)ProfileDao.getBlankOwnersByAirline((DictionaryReference)airlineRef).get(0)).toReference());
        SuStockControlReportPrepareHandler handler = new SuStockControlReportPrepareHandler();
        handler.prepareData(data);
        Set blanks = (Set)data.get("key-batch-data-list");
        Assert.assertEquals((long)70L, (long)blanks.size());
        TestSuStockcontrolReportOverviewRender render = new TestSuStockcontrolReportOverviewRender();
        EntityContainer repDoc = render.renderReport(data);
        ReportFile repFile = (ReportFile)((ReportDocument)repDoc.getEntity()).getFiles().get(0);
        try (FileOutputStream fileOut = new FileOutputStream(this.buildOutputFileName("SuStockcontrolOverview.xls"));){
            ByteArrayInputStream is = new ByteArrayInputStream(repFile.getContent());
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            wb.write((OutputStream)fileOut);
        }
    }

    private File buildOutputFileName(String fileName) throws IOException {
        File result = new File("./test/stockcontrol-reports/");
        if (!result.exists() && !result.mkdirs()) {
            throw new IOException("can't make directory " + result.getCanonicalPath());
        }
        return new File(result, fileName);
    }

    private AirlineReference createAirlineSU() throws Exception {
        return DictHelper.findAirlineByAnyCode((String)"SU").toReference();
    }

    private EntityContainer<Organization> createAgency() throws Exception {
        EntityContainer result = new EntityContainer(Organization.class);
        Organization agency = (Organization)result.getEntity();
        agency.setActive(true);
        L10nStringHelper.setValue((L10nString)agency.getShortName(), (String)"ABC", (Locale)Locale.ENGLISH);
        L10nStringHelper.setValue((L10nString)agency.getFullName(), (String)"ABC agency", (Locale)Locale.ENGLISH);
        agency.setCode("001");
        SystemHelper.setMetadataValue((Collection)agency.getMetadata(), (MetadataKey)MetadataKey.KEY_SU_AGENCY_CODE, (Object)"0001");
        Address address = new Address();
        address.setAddressType(AddressType.CONTACT);
        L10nStringHelper.setValue((L10nString)address.getAddress(), (String)"city street building", (Locale)Locale.ENGLISH);
        agency.getAddresses().add(address);
        Manager man1 = new Manager();
        man1.setName("Chief Accountant");
        man1.setType(ManagerType.CHIEF_ACCOUNTANT);
        agency.getManagers().add(man1);
        Manager man2 = new Manager();
        man2.setName("Director");
        man2.setType(ManagerType.DIRECTOR);
        agency.getManagers().add(man2);
        Manager man3 = new Manager();
        man3.setName("Travel Manager");
        man3.setType(ManagerType.TRAVEL_MANAGER);
        agency.getManagers().add(man3);
        this.save(result);
        return result;
    }

    private void save(EntityContainer<?> ec) throws Exception {
        EntityStorage es = EntityStorage.get();
        String user = LogicalStorage.get().getUser();
        ec.setCreated(new Date());
        ec.setModified(new Date());
        ec.setCreatedBy(user);
        ec.setModifiedBy(user);
        es.save(ec, false);
    }

    private void updateDictionaryCache(BaseDictionary baseDictionary) {
        DictionaryCache.get().put(baseDictionary);
    }

    class TestSuStockcontrolReportOverviewRender
    extends SuStockcontrolReportOverviewRenderHandler {
        TestSuStockcontrolReportOverviewRender() {
        }

        protected File getTemplateFile() throws IOException {
            File result = new File("plugins/com.gridnine.xtrip.common.reports/templates/stockcontrolreports/" + this.getTemplateFileName());
            if (!result.exists()) {
                throw new IOException("Template " + result.getCanonicalPath() + " was not found");
            }
            return result;
        }
    }
}

