// Imports

import com.gridnine.xtrip.common.l10n.model.LocaleHelper
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.helpers.PersonalLocalizableNameFormatter

import java.text.SimpleDateFormat

// Styles
createStyle(name: 'title', h_alignment: 'CENTER', v_alignment: 'CENTER')
createStyle(name: 'titleH1', fontHeight: 12, parent: 'title')
createStyle(name: 'data', h_alignment: 'LEFT', v_alignment: 'CENTER', fontHeight: 8)
createStyle(name: 'dataText', parent: 'data')
createStyle(name: 'avc', v_alignment: 'CENTER')
createStyle(name: 'bold', fontBold: true)

// Closures
def period = {
    SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy")
    def periodBeginParameter = parameters['key-report-params']?.periodBegin
    def periodEndParameter = parameters['key-report-params']?.periodEnd
    return "за период с " +
            (periodBeginParameter ? sdf.format(periodBeginParameter) : "") +
            " по " +
            (periodEndParameter ? sdf.format(periodEndParameter) : "")
}

def accountantName = {
    def person = EntityStorage.get().resolve(requestedParameter('accountant'))?.entity
    def format = new PersonalLocalizableNameFormatter(PersonalLocalizableNameFormatter.SIMPLE)
    return person ? format.format(person, LocaleHelper.getLocale('ru', 'RU'), false) : '?'
}

def counterMTD = {
    int counter = 0
    tickets {
        if (it.fareBasisLine.equals("ZDVO")) counter++
    }
    return counter
}

page { 'Сопроводительное письмо за декаду' } {

    // Set portrait mode
    landscape(false)

    // Set narrow margins
    margin(0.25, 0.25, 0.75, 0.75)

    // Set scale
    scale(100)

    // Set preserve mode
    preserve(false)

// Report
    columnWidth(2)
    text('АК   "Аврора"', 'titleH1|avc|bold', 11, 1)
    rowHeight(20)
    2.times { nextRow() }
    text('Сопроводительное письмо', 'titleH1|avc|bold', 11, 1)
    rowHeight(20)
    nextRow()
    text(period(), 'titleH1|avc|bold', 11, 1)
    rowHeight(20)
    2.times { nextRow() }
    nextColumn()
    text('Количество ВПД МО  - ', 'dataText|bold', 2, 1)
    2.times {nextColumn() }
    text(counterMTD() + ' шт.', 'dataText|bold')
    nextRow()
    nextColumn()
    text('Комплект реестров ВВЛ АВИА - 1 экз.', 'dataText|bold')
    4.times { nextRow() }
    nextColumn()
    text('Претензии по наличию документов, согласно описи, принимаются в течении 2-х отчетных декад.', 'dataText')
    7.times { nextRow() }
    nextColumn()
    text('Бухгалтер:', 'dataText')
    nextColumn()
    text(accountantName(), 'dataText')
}