// Imports
import java.text.SimpleDateFormat
import com.gridnine.xtrip.common.l10n.model.LocaleHelper
import com.gridnine.xtrip.common.model.booking.OperationBatch
import com.gridnine.xtrip.common.model.booking.ProductStatus
import com.gridnine.xtrip.common.model.dict.DictionaryCache
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper
import com.gridnine.xtrip.common.model.helpers.PersonalLocalizableNameFormatter
import com.gridnine.xtrip.common.model.helpers.ProfileHelper
import com.gridnine.xtrip.common.model.helpers.SystemHelper
import com.gridnine.xtrip.common.model.system.MetadataKey
import com.gridnine.xtrip.common.model.system.PaymentType
import com.gridnine.xtrip.common.reports.AgentReportHelper
import com.gridnine.xtrip.common.util.MiscUtil
import com.gridnine.xtrip.common.util.TextUtil

// Styles
createStyle(name: 'title', h_alignment: 'CENTER', v_alignment: 'CENTER')
createStyle(name: 'titleH1', fontHeight: 14, parent: 'title')
createStyle(name: 'titleH2', fontHeight: 9, parent: 'title')
createStyle(name: 'titleH3', fontHeight: 7, parent: 'title')
createStyle(name: 'header', h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight: 7)
createStyle(name: 'columnHeader', parent: 'header')
createStyle(name: 'rowHeader', parent: 'header')
createStyle(name: 'data', h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight: 7)
createStyle(name: 'dataText', parent: 'data')
createStyle(name: 'dataDate', format: 'm/d/yy', parent: 'data')
createStyle(name: 'dataNumber', h_alignment: 'RIGHT', format: '#,##0.00', parent: 'data')
createStyle(name: 'wrap', wrapText: true)
createStyle(name: 'ahl', h_alignment: 'LEFT')
createStyle(name: 'ahc', h_alignment: 'CENTER')
createStyle(name: 'ahr', h_alignment: 'RIGHT')
createStyle(name: 'avt', v_alignment: 'TOP')
createStyle(name: 'avc', v_alignment: 'CENTER')
createStyle(name: 'avb', v_alignment: 'BOTTOM')
createStyle(name: 'aac', h_alignment: 'CENTER', v_alignment: 'CENTER')
createStyle(name: 'bold', fontBold: true)
createStyle(name: 'italic', fontItalic: true)
createStyle(name: 'bt', topBorder: 'THIN')
createStyle(name: 'bl', leftBorder: 'THIN')
createStyle(name: 'bb', bottomBorder: 'THIN')
createStyle(name: 'br', rightBorder: 'THIN')
createStyle(name: 'ba', topBorder: 'THIN', leftBorder: 'THIN', bottomBorder: 'THIN', rightBorder: 'THIN')
createStyle(name: 'grey25', foreground: 'GREY_25_PERCENT')
createStyle(name: 'locked', locked: true)

// Properties
def periodBeginParameter = parameters['key-report-params']?.periodBegin
def periodEndParameter = parameters['key-report-params']?.periodEnd
def supplierParameter = parameters['key-report-params']?.supplier
def agencyParameter = parameters['key-report-params']?.agency

// Closures
def period = {

    def format = new SimpleDateFormat('dd.MM.yyyy')
    return String.format('с %s по %s', periodBeginParameter != null ? format.format(periodBeginParameter) : '?', periodEndParameter != null ? format.format(periodEndParameter) : '?')
}

def agencyName = {

    def organization = EntityStorage.get().resolve(agencyParameter)?.entity
    return organization ? ProfileHelper.getFullName(organization, LocaleHelper.getLocale('ru', 'RU'), false) : 'Не указано'
}

def agencyCode = {

    def organization = EntityStorage.get().resolve(agencyParameter)?.entity
    return organization ? SystemHelper.findMetadataAsString(organization.getMetadata(), MetadataKey.KEY_HZ_AGENCY_CODE) : 'Не указано'
}

page{'Соц. талоны'}{

    // Set portrait mode
    landscape(false)

    // Set narrow margins
    margin(0.25, 0.25, 0.75, 0.75)

    // Set preserve mode
    preserve(false)

    // Report header
    text('ВЕДОМОСТЬ', 'titleH2|bold', 9, 1)
    nextRow()
    text('учета социальных талонов', 'titleH2|bold', 9, 1)
    nextRow()
    text('за период ' + period(), 'titleH2|bold', 9, 1)
    nextRow()
    text(agencyName(), 'titleH2|bold', 9, 1)
    nextRow()

    columnWidth(5)
    nextColumn()
    columnWidth(12)
    nextColumn()
    columnWidth(8)
    nextColumn()
    columnWidth(18)
    nextColumn()
    columnWidth(12)
    nextColumn()
    columnWidth(12)
    nextColumn()
    columnWidth(12)
    nextColumn()
    columnWidth(14)
    nextColumn()
    columnWidth(10)
    nextRow()

    // Table coupons header
    text('№ пп', 'columnHeader|wrap|ba', 1, 2)
    nextColumn()
    text('Номер а/билета', 'columnHeader|wrap|ba', 1, 2)
    nextColumn()
    text('Дата проезда', 'columnHeader|wrap|ba', 1, 2)
    nextColumn()
    text('ФИО', 'columnHeader|wrap|ba', 1, 2)
    nextColumn()
    text('Льготная категория', 'columnHeader|wrap|ba', 1, 2)
    nextColumn()
    text('Номер удостоверения', 'columnHeader|wrap|ba', 1, 2)
    nextColumn()
    text('Серия и номер соц. талона', 'columnHeader|wrap|ba', 1, 2)
    nextColumn()
    text('Маршрут', 'columnHeader|wrap|ba', 1, 2)
    nextColumn()
    text('Стоимость проезда', 'columnHeader|wrap|ba', 1, 2)
    2.times{nextRow()}

    def count = 0

    // Table coupons
    tickets{
        
        if(!it.paymentTypes.contains(PaymentType.CREDIT)) {
            return
        }

        text(String.valueOf(count + 1), 'dataText|wrap|ahr|ba')
        nextColumn()
        text(it.ticketNumber, 'dataText|wrap|ba')
        nextColumn()
        date(it.issueDate, 'dataDate|wrap|ba')
        nextColumn()
        text(it.travellerName, 'dataText|wrap|ba')
        nextColumn()
        text(null, 'dataText|wrap|ba')
        nextColumn()
        text(null, 'dataText|wrap|ba')
        nextColumn()
        text(it.relatedDocumentNumber, 'dataText|wrap|ba')
        nextColumn()
        text(it.routeLine, 'dataText|wrap|ba')
        nextColumn()
        number(it.price, 'dataNumber|wrap|ba')
        nextRow()

        count++
    }

    text('Итого (Total): ' + String.valueOf(count), 'dataText|wrap|ahl|bold|ba', 8, 1)
    8.times{nextColumn()}
    formula(count > 0 ? "SUM(${cellIndex(-count, 0)}:${cellIndex(-1, 0)})" : null, 'dataNumber|wrap|bold|ba')
}
