import com.gridnine.xtrip.common.l10n.model.LocaleHelper
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.helpers.PersonalLocalizableNameFormatter
import com.gridnine.xtrip.common.model.helpers.ProfileHelper

//CREATING STYLES
createStyle(name: 'b', fontBold: true)
createStyle(name: 'f10', fontHeight:10)
createStyle(name: 'f11', fontHeight:11)
createStyle(name: 'hl', h_alignment: 'LEFT')
createStyle(name: 'hr', h_alignment: 'RIGHT')
createStyle(name: 'hc', h_alignment: 'CENTER')
createStyle(name: 'vc', v_alignment: 'CENTER')
createStyle(name: 'sp9', h_span: 9)
createStyle(name: 'sp8', h_span: 8)
createStyle(name: 'sp5', h_span: 5)
createStyle(name: 'sp4', h_span: 4)
createStyle(name: 'sp3', h_span: 3)
createStyle(name: 'sp2', h_span: 2)
createStyle(name: 'thin_b', leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN')
createStyle(name: 'medium_b', leftBorder:'MEDIUM', rightBorder:'MEDIUM', topBorder:'MEDIUM', bottomBorder:'MEDIUM')
createStyle(name: 'date', format: 'm/d/yy')
createStyle(name: 'wrap', wrapText: true)
createStyle(name: 'header',fontBold: false,  h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:10, leftBorder:'MEDIUM', rightBorder:'MEDIUM', topBorder:'MEDIUM', bottomBorder:'MEDIUM', wrapText: true)

//ADDITIONAL FUNCTIONS
def sum = {BigDecimal... values ->
    BigDecimal result = BigDecimal.ZERO
    values.each {
        if(it != null){
            result = result.add(it)
        }
    }
    return result
}
def multi = {BigDecimal... values ->
    BigDecimal result = BigDecimal.ONE
    values.each {
        if(it == null){
            result == BigDecimal.ZERO
            return
        }
        result = result.multiply(it)
    }
    return result
}

def makeTitle = {
    //TITLE
    rowHeight(30)
    text("Отчет - Акт выполненных работ", 'b|sp9|hl|vc|f11')
    rowHeight(15)
    2.times{nextRow()}
}

def makeMainHeader = {
    text('Доверитель', 'sp3|b|hl|vc|f10')
    nextColumn()
    text(parameters.SUPPLIER_NAME, 'sp4|b|hl|vc|f10|thin_b')

    nextRow()
    text('Код ПП, канал продаж:', 'sp3|b|hl|vc|f10')
    nextColumn()
    text(' ', 'sp2|b|hl|vc|f10|thin_b')
    nextColumn()
    text(' ', 'sp2|b|hl|vc|f10|thin_b')

    2.times{nextRow()}
    text('Поверенный:', 'sp3|b|hl|vc|f10')
    nextColumn()
    text(parameters.AGENCY_NAME, 'sp4|b|hl|vc|f10|thin_b')

    nextRow()
    text('№ договора поручения:', 'sp3|b|hl|vc|f10')
    nextColumn()
    text(parameters.SUPPLIER_CONTRACT_NUMBER, 'sp4|b|hl|vc|f10|thin_b')

    nextRow()
    text('дата договора поручения:', 'sp3|b|hl|vc|f10')
    nextColumn()
    date(parameters.SUPPLIER_CONTRACT_ISSUE_DATE, 'sp4|b|hl|vc|f10|thin_b|date')

    nextRow()
    text('Страховой продукт:','sp3|b|hl|vc|f10')
    nextColumn()
    text('НС Авиа', 'sp2|b|hl|vc|f10|thin_b')
    nextColumn()
    text('198', 'sp2|b|hl|vc|f10|thin_b')

    nextRow()
    text('№ отчета:', 'sp3|b|hl|vc|f10')
    nextColumn()
    text(' ', 'sp4|b|hl|vc|f10|thin_b')

    2.times{nextRow()}
    text('Отчетный период:', 'sp3|b|hl|vc|f10')
    nextColumn()
    date(parameters['key-report-params'].periodBegin, 'sp2|b|hl|vc|f10|thin_b|date')
    nextColumn()
    date(parameters['key-report-params'].periodEnd, 'sp2|b|hl|vc|f10|thin_b|date')

    2.times{nextRow()}
}

def makeTableHeader = {
    setStyle('header')
    rowHeight(120)
    columnWidth(5)
    text('№ П/П')
    nextColumn()
    columnWidth(21)
    text('Ф.И.О. сотрудника Поверенного')
    nextColumn()
    columnWidth(13)
    text('№ договора поручения Доверителя с сотрудником Поверенного')
    nextColumn()
    columnWidth(13)
    text('Дата договора поручения между сотрудником Поверенного и Доверителем')
    nextColumn()
    columnWidth(13)
    text('Дата и номер Отчета-Акта по договору поручения между сотрудником Поверенного и Доверителем')
    nextColumn()
    columnWidth(13)
    text('Кол-во закл. Договоров страхования, шт.')
    nextColumn()
    columnWidth(13)
    text('Сумма полученной страховой премии, руб.')
    nextColumn()
    columnWidth(13)
    text('Кол-во расторгнутых договоров страхования, шт.')
    nextColumn()
    columnWidth(15)
    text('Сумма возвращенной страховой премии, руб.')
    nextColumn()
    columnWidth(15)
    text('Разница между полученной и возвращенной страховой премией, руб.')
    nextRow()
    setStyle('normal')
    rowHeight(15)
}

def makeSummary = { saldoCell ->
    setStyle('text')
    text('Разница между полученной и возвращенной страховой премией:', 'sp8|hr|vc|b')
    nextColumn()
    formula("${saldoCell}",'text')
    setStyle('text')
    nextColumn()
    text('рублей')
    nextRow()

    text('Комиссионное вознаграждение Поверенного:', 'sp8|hr|vc|b')
    nextColumn()
    // data input manually into the cell
    text(' ', 'text')
    nextColumn()
    text('%')
    nextRow()

    text(' ', 'sp8|hr|vc|b')
    nextColumn()
    formula("${cellIndex(-2,0)}*(${cellIndex(-1,0)}/100)",'text')
    nextColumn()
    text('рублей')
    nextRow()

    text('в том числе НДС:', 'sp8|hr|vc|b')
    nextColumn()
    formula("${cellIndex(-1,0)}*0.18",'text')
    nextColumn()
    text('рублей')
    nextRow()

    text('Подлежит перечислению Доверителю:', 'sp8|hr|vc|b')
    nextColumn()
    formula("${cellIndex(-4,0)}-${cellIndex(-2,0)}",'text')
    nextColumn()
    text('рублей')
    nextRow()

    nextRow()
    setStyle('normal')
}

def makeFooter = {
    text('Доверитель', 'b|h10|hl|vc|hc|sp3')
    setStyle('normal')
    6.times { nextColumn() }
    text('Поверенный', 'b|h10|hl|vc|hc|sp3')
    setStyle('normal')
    2.times{ nextRow() }
    text(parameters.SUPPLIER_NAME, 'b|h10|hc|vc|sp3')
    setStyle('normal')
    6.times { nextColumn() }
    text(parameters.AGENCY_NAME, 'b|h10|hl|vc|hc|sp3')
    setStyle('normal')
    2.times{ nextRow() }

    def accountant = parameters.get('accountant')   // Главный  бухгалтер
    def principal = parameters.get('principal')     // Доверитель
    def attorney = parameters.get('attorney')       // Поверенный

    text('/ ' + (principal ?: '_____________') + ' /', 'sp3|vc|hr')
    setStyle('normal')
    6.times { nextColumn() }
    text('/ ' + (attorney  ?: '_____________') + ' /', 'sp3|vc|hr')
    setStyle('normal')
    nextRow()
    text('\'___\' \'__________\'  2013 г.', 'sp3|vc|hr')
    setStyle('normal')
    6.times { nextColumn() }
    text('\'___\' \'__________\'  2013 г.', 'sp3|vc|hr')
    setStyle('normal')
    nextRow()
    nextRow()

    6.times {nextColumn() }
    text('Главный бухгалтер', 'b|h10|hl|vc|hc|sp3')
    setStyle('normal')
    nextRow()

    6.times { nextColumn() }
    text('/ ' + (accountant  ?: '_____________') + ' /', 'sp3|vc|hr')
    setStyle('normal')
    nextRow()

    6.times { nextColumn() }
    text('\'___\' \'__________\'  2013 г.', 'sp3|vc|hr')
    setStyle('normal')
    nextRow()
}

def getAgentName = { agentRef ->
    def agent = EntityStorage.get().resolve(agentRef)?.entity;
    return agent ? new PersonalLocalizableNameFormatter('L f m').format(agent, LocaleHelper.getLocale('ru', 'RU'), false) : 'Не указано';
}

//REPORT
page{'Worksheet'}{

    makeTitle()
    makeMainHeader()


    //DATA
    makeTableHeader()
    def num = 1
    String totalCountSellCell = cellIndex(0,5)
    String totalPremiumSellCell = cellIndex(0,6)
    String totalCountVoidCell = cellIndex(0,7)
    String totalPremiumVoidCell = cellIndex(0,8)
    String totalSaldoCell = cellIndex(0,9)

    groups{it.agent?.toString()}{
        def agentRef = null
        def agentName = null
        // make these iterations just to determine status
        tickets{
            if (agentRef == null){
                agentRef = it.agent
            }
        }
        if (agentRef != null){
            agentName = getAgentName(agentRef)
        }

        def totalSellCount = 0
        def totalVoidCount = 0
        def totalSellPremium = 0.0
        def totalVoidPremium = 0.0

        tickets{
            if ('SELL'.equals(it.status?.name())){
                totalSellCount++
                totalSellPremium += it.premium
            } else if ('VOID'.equals(it.status?.name())){
                totalVoidCount++
                totalVoidPremium += it.premium
            }
        }

        number(num,'text')
        num++
        nextColumn()
        text(agentName, 'text')
        nextColumn()
        text(parameters.SUPPLIER_CONTRACT_NUMBER, 'text')
        nextColumn()
        date(parameters.SUPPLIER_CONTRACT_ISSUE_DATE, 'date')
        nextColumn()
        // unknown column data (Дата и номер Отчета-Акта по договору поручения между сотрудником Поверенного и Доверителем)
        nextColumn()
        number(totalSellCount, 'text')
        nextColumn()
        number(totalSellPremium, 'text')
        nextColumn()
        number(totalVoidCount, 'text')
        nextColumn()
        number(totalVoidPremium, 'text')
        nextColumn()
        formula("${cellIndex(0,-3)}-${cellIndex(0,-1)}", 'text')

        nextRow()

    }

    //TOTAL

    text('Итого','sp5|b|hr|vc')
    nextColumn()
    formula("SUM(${totalCountSellCell}:${cellIndex(-1,0)})",'text')
    nextColumn()
    formula("SUM(${totalPremiumSellCell}:${cellIndex(-1,0)})",'text')
    nextColumn()
    formula("SUM(${totalCountVoidCell}:${cellIndex(-1,0)})",'text')
    nextColumn()
    formula("SUM(${totalPremiumVoidCell}:${cellIndex(-1,0)})",'text')
    nextColumn()
    formula("SUM(${totalSaldoCell}:${cellIndex(-1,0)})",'text')
    def saldoCell = cellIndex(0,0)
    nextRow()
    nextRow()
    makeSummary(saldoCell)
    makeFooter()
}