package com.gridnine.xtrip.server.reports.templates

import com.gridnine.xtrip.server.reports.prepare.template.indexbased.primorskoe.mediator.PrimorskoeMediatorReportPrepareHelper

import java.text.SimpleDateFormat

createStyle(name: 'title', h_alignment: 'CENTER', v_alignment: 'CENTER')
createStyle(name: 'titleH1', fontHeight: 12, fontBold: true, parent: 'title')
createStyle(name: 'titleH2', fontHeight: 10, parent: 'title')
createStyle(name: 'header', foreground: 'GREY_25_PERCENT', fontHeight: 8, fontBold: true, h_alignment: 'CENTER', v_alignment: 'TOP', topBorder: 'THIN', leftBorder: 'THIN', rightBorder: 'THIN', bottomBorder: 'THIN')
createStyle(name: 'dataText',  fontHeight: 8, h_alignment: 'CENTER', v_alignment: 'CENTER', topBorder: 'THIN', leftBorder: 'THIN', rightBorder: 'THIN', bottomBorder: 'THIN')
createStyle(name: 'dataDate', format: 'm/d/yy', parent: 'dataText')
createStyle(name: 'dataNumber', h_alignment: 'RIGHT', format: '#,##0.00', parent: 'dataText')
createStyle(name: 'totalText',  fontHeight: 8, fontBold: true, h_alignment: 'LEFT', v_alignment: 'CENTER',  bottomBorder: 'THIN')
createStyle(name: 'totalNumber',  fontHeight: 8, fontBold: true, h_alignment: 'RIGHT', format: '#,##0.00', v_alignment: 'CENTER',  bottomBorder: 'THIN')
createStyle(name: 'lineText',  fontHeight: 8,  h_alignment: 'RIGHT',  v_alignment: 'CENTER',  bottomBorder: 'THIN')
createStyle(name: 'footerSmall',  fontHeight: 8,  h_alignment: 'LEFT',  v_alignment: 'CENTER')

createStyle(name: 'footerDate',  fontHeight: 8, format: 'm/d/yy', h_alignment: 'LEFT',  v_alignment: 'CENTER')


def reportData = PrimorskoeMediatorReportPrepareHelper.prepareReport(allTickets)
def format = new SimpleDateFormat("dd/MM/yyyy")
def startDate = parameters["params"].periodBegin
def endDate = parameters["params"].periodEnd
startDate = startDate? format.format(startDate):""
endDate = endDate? format.format(endDate):""
reportData.batches.forEach{ batch ->
    page{"$batch.mediatorName реестр".toString()}{
        landscape(false)
        margin(0.2, 0.2, 0.2, 0.2)
        rowHeight(20);
        text("Реестр продажи и начисления", "titleH1", 10, 1)
        nextRow();
        rowHeight(70);
        text("между $reportData.primorskoeShortName и $batch.mediatorName\n"+
                "по начислению комиссионного вознаграждения\n"+
                "согласно договору $batch.contractNumber \n"+
                "в период с ${startDate} по ${endDate}", "titleH2", 10, 1)
        nextRow()
        rowHeight(40);
        columnWidth(4);
        text("№\nп/п", "header");nextColumn()
        columnWidth(6);
        text("вал-р", "header");nextColumn()
        columnWidth(9);
        text("дата оп.", "header");nextColumn()
        columnWidth(13);
        text("№ а/билета", "header");nextColumn()
        columnWidth(5);
        text("АК", "header");nextColumn()
        columnWidth(9);
        text("Тариф", "header");nextColumn()
        columnWidth(10);
        text("Стоимость", "header");nextColumn()
        columnWidth(6);
        text("ФО", "header");nextColumn()
        columnWidth(12);
        text("Сумма возн.\nклиента\nк выплате", "header");nextColumn()
        columnWidth(27);
        text("ФИО пассажира", "header");
        int n = 0;
        batch.registryData.items.forEach{ item ->
            n++
            nextRow()
            rowHeight(12);
            text(n+"", 'dataText')
            nextColumn()
            text(item.validatorCode, 'dataText')
            nextColumn()
            date(item.operationDate, 'dataDate')
            nextColumn()
            text(item.ticketNumber, 'dataText')
            nextColumn()
            text(item.airline, 'dataText')
            nextColumn()
            number(item.tariff, 'dataNumber')
            nextColumn()
            number(item.cost, 'dataNumber')
            nextColumn()
            text(item.fopsString, 'dataText')
            nextColumn()
            number(item.commission, 'dataNumber')
            nextColumn()
            text(item.passengerName, 'dataText')
        }
        nextRow()
        rowHeight(12);
        text("Итого:", 'totalText', 5,1);nextColumn()
        nextColumn();nextColumn();nextColumn();nextColumn();
        number(batch.registryData.totalTariff,'totalNumber');nextColumn();
        number(batch.registryData.totalCost,'totalNumber');nextColumn();
        text("", 'totalText');nextColumn()
        number(batch.registryData.totalCommission,'totalNumber');nextColumn()
        text("", 'totalText');
        2.times {nextRow()}
        rowHeight(30);
        2.times {nextColumn()}
        text("Генеральный директор\n"+reportData.primorskoeFullName, "titleH2",4,1)
        5.times {nextColumn()}
        text(batch.mediatorName, "titleH2",3,1)
        2.times {nextRow();rowHeight(12)}
        nextColumn();
        text(reportData.directorName, "lineText",5,1)
        6.times {nextColumn()}
        text("", "lineText",3,1)
        2.times {nextRow()}
        nextColumn()
        text("Исполнитель:", "footerSmall",2,1)
        2.times {nextColumn()}
        text("", "lineText",2,1)
        2.times {nextColumn()}
        text(reportData.executrorName, "footerSmall",2,1)
        2.times {nextRow()}
        nextColumn()
        text("Телефон: " + reportData.primorskoePhoneNumber, "footerSmall",4,1)
        nextRow();
        nextColumn();
        date(new Date(), "footerDate", 2,1)

    }
    page{"$batch.mediatorName акт".toString()}{
        landscape(false)
        margin(0.2, 0.2, 0.2, 0.2)
        rowHeight(20);
        text("АКТ КОМИССИОННОГО ВОЗНАГРАЖДЕНИЯ", "titleH1", 9, 1)
        nextRow();
        rowHeight(50);
        text("между $reportData.primorskoeShortName и $batch.mediatorName\n"+
                "согласно договору $batch.contractNumber \n"+
                "в период с ${startDate} по ${endDate}", "titleH2", 9, 1)
        nextRow()
        rowHeight(40);
        2.times {nextColumn()}
        columnWidth(4);
        text("№\nп/п", "header");nextColumn()
        columnWidth(10);
        text("АК", "header");nextColumn()
        columnWidth(15);
        text("Сумма тарифа", "header");nextColumn()
        columnWidth(15);
        text("Сумма возн.\nклиента\nк выплате", "header");nextColumn()
        columnWidth(15);
        text("Стоимость билета", "header");nextColumn()
        int n=0;
        batch.summaryData.items.forEach{ item ->
            n++;
            nextRow()
            2.times {nextColumn()}
            rowHeight(12);
            text(n+"", 'dataText')
            nextColumn()
            text(item.airline, 'dataText')
            nextColumn()
            number(item.tariff, 'dataNumber')
            nextColumn()
            number(item.commission, 'dataNumber')
            nextColumn()
            number(item.cost, 'dataNumber')
        }
        nextRow()
        rowHeight(12);
        2.times {nextColumn()}
        text("Итого:", 'totalText', 2,1);nextColumn()
        number(batch.summaryData.totalTariff,'totalNumber');nextColumn();
        number(batch.summaryData.totalCommission,'totalNumber');nextColumn()
        number(batch.summaryData.totalCost,'totalNumber');nextColumn();
        2.times {nextRow()}
        rowHeight(30);
        1.times {nextColumn()}
        text("Генеральный директор\n"+reportData.primorskoeFullName, "titleH2",4,1)
        5.times {nextColumn()}
        text(batch.mediatorName, "titleH2",3,1)
        2.times {nextRow();rowHeight(12)}
        nextColumn();
        text(reportData.directorName, "lineText",4,1)
        5.times {nextColumn()}
        text("", "lineText",3,1)
        2.times {nextRow()}
        nextColumn()
        text("Исполнитель:", "footerSmall",2,1)
        2.times {nextColumn()}
        text("", "lineText",2,1)
        2.times {nextColumn()}
        text(reportData.executrorName, "footerSmall",2,1)
        2.times {nextRow()}
        nextColumn()
        text("Телефон: " + reportData.primorskoePhoneNumber, "footerSmall",3,1)
        nextRow();
        nextColumn();
        date(new Date(), "footerDate", 2,1)
    }

}