/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.sd;

import com.gridnine.xtrip.common.model.system.RequestMethod;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.sd.model.CommentResponse;
import com.gridnine.xtrip.server.sd.model.CreateTicketResponse;
import com.gridnine.xtrip.server.sd.model.EventResponse;
import com.gridnine.xtrip.server.sd.model.GetTicketResponse;
import com.gridnine.xtrip.server.sd.model.Response;

public enum SDEndpoint {
    EVENT("api/v1/servicedesk/sabre/event", RequestMethod.POST, EventResponse.class),
    COMMENT("api/v1/servicedesk/sabre/ticket/%s/comment", RequestMethod.POST, CommentResponse.class),
    GET_TICKET("api/v1/servicedesk/sabre/ticket/SABRE_%s", RequestMethod.GET, GetTicketResponse.class),
    CREATE_TICKET("api/v1/servicedesk/sabre/ticket", RequestMethod.POST, CreateTicketResponse.class);

    private final String endpoint;
    private final RequestMethod method;
    private final Class<? extends Response> responseClass;

    private SDEndpoint(String endpoint, RequestMethod method, Class<? extends Response> responseClass) {
        this.endpoint = endpoint;
        this.method = method;
        this.responseClass = responseClass;
    }

    public String createUrl(String serverAddress) {
        TextUtil.requireNonBlank((String)serverAddress, (String)"Server address is missing");
        String address = serverAddress.trim();
        if (!address.trim().endsWith("/")) {
            address = address + "/";
        }
        return address + this.endpoint;
    }

    public RequestMethod getMethod() {
        return this.method;
    }

    public Class<? extends Response> getResponseClass() {
        return this.responseClass;
    }
}

