/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.sd;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gridnine.xtrip.common.helper.UniqueSettingsRegistry;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ExternalSystem;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.Post;
import com.gridnine.xtrip.common.model.profile.ExternalSystemCodeV2;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.sd.IbusSDContextKeys;
import com.gridnine.xtrip.common.model.sd.SDSettings;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.sd.model.BaseResponse;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDHelper {
    public static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final Logger log = LoggerFactory.getLogger((String)SDHelper.class.getName());

    private SDHelper() {
    }

    public static SDSettings getSettings() {
        String settingsUid = UniqueSettingsRegistry.get().getUidByClassName(SDSettings.class.getName());
        EntityContainer settings = EntityStorage.get().load(SDSettings.class, settingsUid);
        return EntityStorageHelper.nonEmpty((EntityContainer)settings) ? (SDSettings)settings.getEntity() : null;
    }

    public static boolean isDisabled() {
        SDSettings settings = SDHelper.getSettings();
        return settings == null || !settings.isSyncEnabled();
    }

    public static DictionaryReference<ExternalSystem> getExternalSystem() {
        SDSettings settings = SDHelper.getSettings();
        return settings == null ? null : settings.getExternalSystem();
    }

    public static boolean isInvalid() {
        SDSettings settings = SDHelper.getSettings();
        return settings == null || settings.getExternalSystem() == null || TextUtil.isBlank((String)settings.getLogin()) || TextUtil.isBlank((String)settings.getPassword()) || TextUtil.isBlank((String)settings.getServerAddress());
    }

    private static Set<String> getCodes(EntityContainer<BookingFile> bookingFile) {
        Set<String> codes = ((BookingFile)bookingFile.getEntity()).getExternalCodes().stream().filter(e -> MiscUtil.equals(SDHelper.getExternalSystem(), (Object)e.getSystem())).map(ExternalSystemCodeV2::getCode).collect(Collectors.toSet());
        if (codes.isEmpty()) {
            codes.add(null);
        }
        return codes;
    }

    public static String getClientCode(BookingFile bookingFile) {
        if (bookingFile == null) {
            return null;
        }
        String clientCode = null;
        EntityReference clientRef = bookingFile.getCustomerProfile();
        if (clientRef != null) {
            EntityContainer clientCtr = EntityStorage.get().resolve(clientRef);
            clientCode = clientCtr != null ? ((Organization)clientCtr.getEntity()).getCode() : clientRef.getCaption();
        }
        return clientCode;
    }

    public static void sendComment(List<Post> posts, EntityContainer<BookingFile> bookingFile) {
        Set<String> codes = SDHelper.getCodes(bookingFile);
        String client = SDHelper.getClientCode((BookingFile)bookingFile.getEntity());
        codes.forEach(code -> posts.forEach(post -> {
            HashMap<String, Object> contextData = new HashMap<String, Object>();
            contextData.put(IbusSDContextKeys.POST.name(), post);
            contextData.put(IbusSDContextKeys.CODE.name(), code);
            contextData.put(IbusSDContextKeys.BOOKING_FILE.name(), bookingFile);
            contextData.put(IbusSDContextKeys.TICKET_AUTHOR.name(), SDHelper.getTicketAuthor((BookingFile)bookingFile.getEntity()));
            contextData.put(IbusSDContextKeys.SAVE_BOOKING_FILE.name(), true);
            try {
                log.debug(String.format("Send comment to SD for ticket number %s booking number %s and client %s started", String.join((CharSequence)", ", codes), ((BookingFile)bookingFile.getEntity()).getNumber(), client));
                IntegrationBusFacade.get().processRouteSync("sd:comment", contextData);
                log.debug(String.format("Send comment to SD for ticket number %s booking number %s and client %s ended", String.join((CharSequence)", ", codes), ((BookingFile)bookingFile.getEntity()).getNumber(), client));
            }
            catch (Throwable t) {
                log.error(String.format("Failed send comment to SD for ticket number %s booking number %s and client %s", String.join((CharSequence)", ", codes), ((BookingFile)bookingFile.getEntity()).getNumber(), client), t);
            }
        }));
    }

    public static void sendEvent(String eventCode, EntityContainer<BookingFile> bookingFile, String message) {
        SDHelper.sendEvent(eventCode, bookingFile, BookingHelper.getProducts((BookingFile)((BookingFile)bookingFile.getEntity())), message);
    }

    public static void sendEvent(String eventCode, EntityContainer<BookingFile> bookingFile, Collection<BaseProduct> baseProducts, String message) {
        Set<String> codes = SDHelper.getCodes(bookingFile);
        String client = SDHelper.getClientCode((BookingFile)bookingFile.getEntity());
        codes.forEach(code -> {
            HashMap<String, Object> contextData = new HashMap<String, Object>();
            contextData.put(IbusSDContextKeys.EVENT_CODE.name(), eventCode);
            contextData.put(IbusSDContextKeys.BOOKING_FILE.name(), bookingFile);
            contextData.put(IbusSDContextKeys.CODE.name(), code);
            contextData.put(IbusSDContextKeys.MESSAGE.name(), message);
            contextData.put(IbusSDContextKeys.TICKET_AUTHOR.name(), SDHelper.getTicketAuthor(baseProducts));
            try {
                log.debug(String.format("Send event %s to SD for ticket number %s booking number %s and client %s started", eventCode, String.join((CharSequence)", ", codes), ((BookingFile)bookingFile.getEntity()).getNumber(), client));
                IntegrationBusFacade.get().processRouteSync("sd:event", contextData);
                log.debug(String.format("Send event %s to SD for ticket number %s booking number %s and client %s ended", eventCode, String.join((CharSequence)", ", codes), ((BookingFile)bookingFile.getEntity()).getNumber(), client));
            }
            catch (Throwable t) {
                log.error(String.format("Failed send event %s to SD for ticket number %s booking number %s and client %s", eventCode, String.join((CharSequence)", ", codes), ((BookingFile)bookingFile.getEntity()).getNumber(), client), t);
            }
        });
    }

    public static void handleResponseError(BaseResponse response, String method) {
        if (TextUtil.nonBlank((String)response.getError())) {
            throw Xeption.forDeveloper((String)String.format("SD %s error:\n%s\nDescription:\n%s", method, response.getError(), response.getError_description()), (Object[])new Object[0]);
        }
    }

    public static Author getTicketAuthor(BookingFile bookingFile) {
        return SDHelper.getTicketAuthor(BookingHelper.getProducts((BookingFile)bookingFile));
    }

    public static Author getTicketAuthor(Collection<BaseProduct> baseProducts) {
        return SDHelper.buildAuthor(baseProducts.stream().flatMap(bp -> GeneralProductHelper.getHandler((BaseProduct)bp).getTravellers(bp).stream()).filter(Objects::nonNull).map(Traveller::getPassenger)).orElse(SDHelper.buildAuthor(baseProducts.stream().map(BaseProduct::getReservation).map(Reservation::getBookingAgent)).orElse(SDHelper.buildAuthor(baseProducts.stream().map(bp -> GeneralProductHelper.getHandler((BaseProduct)bp).findIssuingAgent(bp))).orElse(null)));
    }

    private static Optional<Author> buildAuthor(Stream<EntityReference<Person>> personsStream) {
        return personsStream.filter(Objects::nonNull).map(p -> EntityStorage.get().resolve(p)).filter(Objects::nonNull).filter(p -> ((Person)p.getEntity()).getLoginName() != null).findFirst().map(p -> new Author(p.getUid(), ProfileHelper.getFullName((Person)((Person)p.getEntity()), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false), ProfileHelper.getCommunicationEmail((List)((Person)p.getEntity()).getCommunications())));
    }

    public static class Author {
        private String uid;
        private String name;
        private String email;

        public Author() {
        }

        public Author(String uid, String name, String email) {
            this.uid = uid;
            this.name = name;
            this.email = email;
        }

        public String getUid() {
            return this.uid;
        }

        public String getName() {
            return this.name;
        }

        public String getEmail() {
            return this.email;
        }
    }
}

