/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.sd.ibus;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.Post;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.sd.IbusSDContextKeys;
import com.gridnine.xtrip.common.model.sd.SDSettings;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.sd.SDEndpoint;
import com.gridnine.xtrip.server.sd.model.CommentRequest;
import com.gridnine.xtrip.server.sd.model.SDParameters;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;

public class CommentRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SDSettings settings = (SDSettings)ctx.getMandatoryObject((Enum)IbusSDContextKeys.SETTINGS);
        String code = (String)ctx.getMandatoryObject((Enum)IbusSDContextKeys.CODE);
        Post post = (Post)ctx.getMandatoryObject((Enum)IbusSDContextKeys.POST);
        CommentRequest request = CommentRequest.builder().build();
        Optional.ofNullable(post.getAuthor()).ifPresent(p -> {
            EntityContainer person = EntityStorage.get().resolve(p);
            if (person == null) {
                return;
            }
            request.setPersonUid(person.getUid());
            request.setAuthorName(ProfileHelper.getFullName((Person)((Person)person.getEntity()), (Locale)LocaleManager.get().getCurrentLocale(), (boolean)false));
            ((Person)person.getEntity()).getCommunications().stream().filter(c -> c.getType() == CommunicationType.EMAIL).findFirst().ifPresent(e -> request.setAuthorEmail(e.getSense()));
        });
        request.setText(post.getContent());
        post.getAttachments().forEach(a -> {
            EntityContainer doc = EntityStorage.get().resolve(a);
            if (doc == null) {
                return;
            }
            CommentRequest.File file = CommentRequest.File.builder().build();
            file.setTitle(((Document)doc.getEntity()).getName());
            file.setFile(Base64.encode((byte[])((Document)doc.getEntity()).getContent()));
            if (request.getFiles() == null) {
                request.setFiles(new ArrayList<CommentRequest.File>());
            }
            request.getFiles().add(file);
        });
        request.setPostDate(post.getDateCreated());
        SDParameters parameters = SDParameters.builder().build();
        parameters.setPayload(request);
        parameters.setUrl(String.format(SDEndpoint.COMMENT.createUrl(settings.getServerAddress()), code));
        parameters.setMethod(SDEndpoint.COMMENT.getMethod());
        parameters.setResponseClass(SDEndpoint.COMMENT.getResponseClass());
        ctx.putObject((Enum)IbusSDContextKeys.REQUEST_PARAMETERS, (Object)parameters);
    }
}

