/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.sd.ibus;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.sd.IbusSDContextKeys;
import com.gridnine.xtrip.common.model.sd.SDSettings;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.sd.SDEndpoint;
import com.gridnine.xtrip.server.sd.SDHelper;
import com.gridnine.xtrip.server.sd.model.CreateTicketRequest;
import com.gridnine.xtrip.server.sd.model.SDParameters;

public class CreateSDTicketRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer clientCtr;
        EntityReference clientRef;
        SDSettings settings = (SDSettings)ctx.getMandatoryObject((Enum)IbusSDContextKeys.SETTINGS);
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IbusSDContextKeys.BOOKING_FILE);
        SDHelper.Author ticketAuthor = (SDHelper.Author)ctx.getObject((Enum)IbusSDContextKeys.TICKET_AUTHOR);
        CreateTicketRequest request = CreateTicketRequest.builder().build();
        request.setTitle("\u0417\u0430\u043a\u0430\u0437 \u2116" + ((BookingFile)bookingFile.getEntity()).getNumber());
        request.setSabreOrderId(((BookingFile)bookingFile.getEntity()).getNumber());
        request.setSabreOrderUid(bookingFile.getUid());
        if (ticketAuthor != null) {
            request.setAuthorName(ticketAuthor.getName());
            request.setAuthorEmail(ticketAuthor.getEmail());
            request.setPersonUid(ticketAuthor.getUid());
        }
        if ((clientRef = ((BookingFile)bookingFile.getEntity()).getCustomerProfile()) != null && (clientCtr = EntityStorage.get().resolve(clientRef)) != null) {
            request.setServiceDeskExternalSystemCode(((Organization)clientCtr.getEntity()).getCode());
        }
        SDParameters parameters = SDParameters.builder().build();
        parameters.setPayload(request);
        parameters.setUrl(SDEndpoint.CREATE_TICKET.createUrl(settings.getServerAddress()));
        parameters.setMethod(SDEndpoint.CREATE_TICKET.getMethod());
        parameters.setResponseClass(SDEndpoint.CREATE_TICKET.getResponseClass());
        ctx.putObject((Enum)IbusSDContextKeys.REQUEST_PARAMETERS, (Object)parameters);
    }
}

