/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.sd.ibus;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.sd.IbusSDContextKeys;
import com.gridnine.xtrip.common.model.sd.SDSettings;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.sd.SDEndpoint;
import com.gridnine.xtrip.server.sd.model.EventRequest;
import com.gridnine.xtrip.server.sd.model.SDParameters;

public class EventRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SDSettings settings = (SDSettings)ctx.getMandatoryObject((Enum)IbusSDContextKeys.SETTINGS);
        String code = (String)ctx.getMandatoryObject((Enum)IbusSDContextKeys.CODE);
        String text = (String)ctx.getMandatoryObject((Enum)IbusSDContextKeys.MESSAGE);
        String eventCode = (String)ctx.getMandatoryObject((Enum)IbusSDContextKeys.EVENT_CODE);
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IbusSDContextKeys.BOOKING_FILE);
        EventRequest request = EventRequest.builder().build();
        request.setText(text);
        request.setTicketId(Integer.valueOf(code));
        request.setOrderId(((BookingFile)bookingFile.getEntity()).getNumber());
        request.setEventType(eventCode);
        SDParameters parameters = SDParameters.builder().build();
        parameters.setPayload(request);
        parameters.setUrl(String.format(SDEndpoint.EVENT.createUrl(settings.getServerAddress()), code));
        parameters.setMethod(SDEndpoint.EVENT.getMethod());
        parameters.setResponseClass(SDEndpoint.EVENT.getResponseClass());
        ctx.putObject((Enum)IbusSDContextKeys.REQUEST_PARAMETERS, (Object)parameters);
    }
}

