/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.sd.ibus;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.ExternalSystemCodeV2;
import com.gridnine.xtrip.common.model.sd.IbusSDContextKeys;
import com.gridnine.xtrip.common.model.sd.SDSettings;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.sd.SDHelper;
import com.gridnine.xtrip.server.sd.model.GetTicketResponse;

public class GetSDTicketResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GetTicketResponse response = (GetTicketResponse)ctx.getMandatoryObject((Enum)IbusSDContextKeys.RESPONSE);
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IbusSDContextKeys.BOOKING_FILE);
        SDSettings settings = (SDSettings)ctx.getMandatoryObject((Enum)IbusSDContextKeys.SETTINGS);
        Boolean save = (Boolean)ctx.getObject((Enum)IbusSDContextKeys.SAVE_BOOKING_FILE);
        if (TextUtil.nonBlank((String)response.getError())) {
            if ("not_found".equals(response.getError())) {
                return;
            }
            SDHelper.handleResponseError(response, "get_ticket");
        }
        if (TextUtil.isBlank((String)response.getId())) {
            throw Xeption.forDeveloper((String)"No ticket number received", (Object[])new Object[0]);
        }
        ExternalSystemCodeV2 code = new ExternalSystemCodeV2();
        code.setSystem(settings.getExternalSystem());
        code.setCode(response.getId());
        ((BookingFile)bookingFile.getEntity()).getExternalCodes().add(code);
        if (BooleanUtil.nullAsFalse((Boolean)save)) {
            bookingFile.getVersionInfo().setDataSource("sd-update");
            EntityStorage.get().save(bookingFile, true);
        }
        ctx.putObject((Enum)IbusSDContextKeys.CODE, (Object)response.getId());
    }
}

