/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.sd.ibus;

import com.gridnine.xtrip.common.model.sd.IbusSDContextKeys;
import com.gridnine.xtrip.common.model.sd.SDSettings;
import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.gridnine.xtrip.server.sd.SDHelper;
import com.gridnine.xtrip.server.sd.model.SDParameters;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;

public class SDRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SDParameters parameters = (SDParameters)ctx.getMandatoryObject((Enum)IbusSDContextKeys.REQUEST_PARAMETERS);
        SDSettings settings = (SDSettings)ctx.getMandatoryObject((Enum)IbusSDContextKeys.SETTINGS);
        HttpRequest request = new HttpRequest();
        request.setUrl(parameters.getUrl());
        if (parameters.getPayload() != null) {
            request.setBody(this.buildContent(parameters.getPayload()));
        }
        request.setRequestMethod(parameters.getMethod());
        request.getRequestProperties().put((Object)"Content-Type", (Object)"application/json");
        request.getRequestProperties().put((Object)"X-USED-EXTERNAL", (Object)"1");
        request.getRequestProperties().put((Object)"Authorization", (Object)("Basic " + Base64.encodeBase64String((byte[])(TextUtil.nonBlankStr((String)settings.getLogin()) + ":" + TextUtil.nonBlankStr((String)settings.getPassword())).getBytes())));
        ctx.putObject((Enum)IBusHttpContextKeys.HTTP_REQUEST, (Object)request);
    }

    private byte[] buildContent(Object request) throws Exception {
        String content = SDHelper.MAPPER.writeValueAsString(request);
        return content.getBytes(StandardCharsets.UTF_8);
    }
}

