/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.sd.ibus;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.sd.IbusSDContextKeys;
import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.gridnine.xtrip.server.sd.SDHelper;
import com.gridnine.xtrip.server.sd.model.Response;
import com.gridnine.xtrip.server.sd.model.SDParameters;

public class SDResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Response result;
        SDParameters parameters = (SDParameters)ctx.getMandatoryObject((Enum)IbusSDContextKeys.REQUEST_PARAMETERS);
        HttpResponse response = (HttpResponse)ctx.getMandatoryObject((Enum)IBusHttpContextKeys.HTTP_RESPONSE);
        if (401 == response.getResponseCode()) {
            throw Xeption.forEndUser((String)"unauthorized request", (Object[])new Object[0]);
        }
        if (response.getResponseCode() == 204) {
            ctx.putObject((Enum)IbusSDContextKeys.RESPONSE, (Object)parameters.getResponseClass().newInstance());
            return;
        }
        String body = null;
        if (response.getError() != null) {
            body = new String(response.getError());
        } else if (response.getBody() != null) {
            body = new String(response.getBody());
        }
        if (body != null) {
            result = (Response)SDHelper.MAPPER.readValue(body, parameters.getResponseClass());
        } else if (response.getResponseCode() == 200) {
            result = parameters.getResponseClass().newInstance();
        } else {
            throw Xeption.forEndUser((String)"unknown response", (Object[])new Object[0]);
        }
        ctx.putObject((Enum)IbusSDContextKeys.RESPONSE, (Object)result);
    }
}

