/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.sd.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.gridnine.xtrip.server.sd.model.BaseRequest;
import java.util.Date;
import java.util.List;

@JsonDeserialize(builder=CommentRequestBuilder.class)
public class CommentRequest
extends BaseRequest {
    @JsonProperty(value="text")
    private String text;
    @JsonProperty(value="authorName")
    private String authorName;
    @JsonProperty(value="authorEmail")
    private String authorEmail;
    @JsonProperty(value="personUid")
    private String personUid;
    @JsonProperty(value="postDate")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
    private Date postDate;
    @JsonProperty(value="files")
    private List<File> files;

    CommentRequest(String text, String authorName, String authorEmail, String personUid, Date postDate, List<File> files) {
        this.text = text;
        this.authorName = authorName;
        this.authorEmail = authorEmail;
        this.personUid = personUid;
        this.postDate = postDate;
        this.files = files;
    }

    public static CommentRequestBuilder builder() {
        return new CommentRequestBuilder();
    }

    public String getText() {
        return this.text;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public String getAuthorEmail() {
        return this.authorEmail;
    }

    public String getPersonUid() {
        return this.personUid;
    }

    public Date getPostDate() {
        return this.postDate;
    }

    public List<File> getFiles() {
        return this.files;
    }

    @JsonProperty(value="text")
    public void setText(String text) {
        this.text = text;
    }

    @JsonProperty(value="authorName")
    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    @JsonProperty(value="authorEmail")
    public void setAuthorEmail(String authorEmail) {
        this.authorEmail = authorEmail;
    }

    @JsonProperty(value="personUid")
    public void setPersonUid(String personUid) {
        this.personUid = personUid;
    }

    @JsonProperty(value="postDate")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
    public void setPostDate(Date postDate) {
        this.postDate = postDate;
    }

    @JsonProperty(value="files")
    public void setFiles(List<File> files) {
        this.files = files;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class CommentRequestBuilder {
        private String text;
        private String authorName;
        private String authorEmail;
        private String personUid;
        private Date postDate;
        private List<File> files;

        CommentRequestBuilder() {
        }

        @JsonProperty(value="text")
        public CommentRequestBuilder text(String text) {
            this.text = text;
            return this;
        }

        @JsonProperty(value="authorName")
        public CommentRequestBuilder authorName(String authorName) {
            this.authorName = authorName;
            return this;
        }

        @JsonProperty(value="authorEmail")
        public CommentRequestBuilder authorEmail(String authorEmail) {
            this.authorEmail = authorEmail;
            return this;
        }

        @JsonProperty(value="personUid")
        public CommentRequestBuilder personUid(String personUid) {
            this.personUid = personUid;
            return this;
        }

        @JsonProperty(value="postDate")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
        public CommentRequestBuilder postDate(Date postDate) {
            this.postDate = postDate;
            return this;
        }

        @JsonProperty(value="files")
        public CommentRequestBuilder files(List<File> files) {
            this.files = files;
            return this;
        }

        public CommentRequest build() {
            return new CommentRequest(this.text, this.authorName, this.authorEmail, this.personUid, this.postDate, this.files);
        }

        public String toString() {
            return "CommentRequest.CommentRequestBuilder(text=" + this.text + ", authorName=" + this.authorName + ", authorEmail=" + this.authorEmail + ", personUid=" + this.personUid + ", postDate=" + this.postDate + ", files=" + this.files + ")";
        }
    }

    @JsonDeserialize(builder=FileBuilder.class)
    public static class File {
        @JsonProperty(value="title")
        private String title;
        @JsonProperty(value="file")
        private String file;

        File(String title, String file) {
            this.title = title;
            this.file = file;
        }

        public static FileBuilder builder() {
            return new FileBuilder();
        }

        public String getTitle() {
            return this.title;
        }

        public String getFile() {
            return this.file;
        }

        @JsonProperty(value="title")
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty(value="file")
        public void setFile(String file) {
            this.file = file;
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class FileBuilder {
            private String title;
            private String file;

            FileBuilder() {
            }

            @JsonProperty(value="title")
            public FileBuilder title(String title) {
                this.title = title;
                return this;
            }

            @JsonProperty(value="file")
            public FileBuilder file(String file) {
                this.file = file;
                return this;
            }

            public File build() {
                return new File(this.title, this.file);
            }

            public String toString() {
                return "CommentRequest.File.FileBuilder(title=" + this.title + ", file=" + this.file + ")";
            }
        }
    }
}

