/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.sd.storage;

import com.gridnine.xtrip.common.ibecorp.model.helpers.TravelPolicyAuthorizationHelper;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.transfer.TransferHelper;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ExternalSystem;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AeroExpressHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.XtripPriceStructureHelper;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationStatus;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.sd.SDHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDBookingFileInterceptor
implements EntityInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SDBookingFileInterceptor.class);
    private static final Set<Class<? extends BaseProduct>> applicableClasses = new HashSet<Class<? extends BaseProduct>>();

    public double getPriority() {
        return Double.MIN_VALUE;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        if (SDHelper.isDisabled()) {
            return;
        }
        DictionaryReference<ExternalSystem> settingSystem = SDHelper.getExternalSystem();
        if (settingSystem == null) {
            log.warn("Service desk settings are enabled but external system is not set");
            return;
        }
        if (SDHelper.isInvalid()) {
            log.warn("Service desk settings are not filled");
            return;
        }
        EntityContainer<?> bookingFileCtr = data;
        EntityContainer oldBookingFileCtr = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
        BookingFile oldBookingFile = oldBookingFileCtr == null ? null : (BookingFile)oldBookingFileCtr.getEntity();
        this.authorizationStatus(bookingFileCtr, oldBookingFile);
        this.newSale(bookingFileCtr, oldBookingFile);
        this.reservationError(bookingFileCtr, oldBookingFile);
        this.reject(bookingFileCtr, oldBookingFile);
        this.voidRefund(bookingFileCtr, oldBookingFile);
        this.cancelAviaRailwayBeforeIssue(bookingFileCtr, oldBookingFile);
        this.priceChange(bookingFileCtr, oldBookingFile);
    }

    private void authorizationStatus(EntityContainer<BookingFile> bookingFile, BookingFile oldBookingFile) {
        HashMap oldUids = oldBookingFile == null ? new HashMap() : BookingStreamHelper.getBaseProductsStream((BookingFile)oldBookingFile).filter(p -> TravelPolicyAuthorizationHelper.getAuthorizationStatus((BaseProduct)p) != null).collect(Collectors.toMap(BaseIdentity::getUid, TravelPolicyAuthorizationHelper::getAuthorizationStatus));
        Map<BaseProduct, TravelPolicyAuthorizationStatus> numbers = BookingStreamHelper.getBaseProductsStream((BookingFile)((BookingFile)bookingFile.getEntity())).filter(p -> {
            TravelPolicyAuthorizationStatus newStatus = TravelPolicyAuthorizationHelper.getAuthorizationStatus((BaseProduct)p);
            TravelPolicyAuthorizationStatus oldStatus = (TravelPolicyAuthorizationStatus)oldUids.get(p.getUid());
            return oldStatus != null && oldStatus != newStatus;
        }).collect(Collectors.toMap(p -> p, TravelPolicyAuthorizationHelper::getAuthorizationStatus));
        if (!numbers.isEmpty()) {
            SDHelper.sendEvent("202", bookingFile, numbers.keySet(), numbers.entrySet().stream().map(e -> L10nResourcesManager.getStr((String)"AUTH_STATUS_CHANGE", (Object[])new Object[]{((BookingFile)bookingFile.getEntity()).getNumber(), String.join((CharSequence)", ", GeneralProductHelper.getHandler((BaseProduct)((BaseProduct)e.getKey())).getProductNumbers((BaseProduct)e.getKey())), oldUids.get(((BaseProduct)e.getKey()).getUid()), e.getValue()})).collect(Collectors.joining("\n")));
        }
    }

    private void newSale(EntityContainer<BookingFile> bookingFile, BookingFile oldBookingFile) {
        ArrayList oldUids = oldBookingFile == null ? new ArrayList() : BookingStreamHelper.getBaseProductsStream((BookingFile)oldBookingFile).filter(p -> GeneralProductHelper.getStatus((BaseProduct)p) == ProductStatus.SELL).map(BaseIdentity::getUid).collect(Collectors.toList());
        List<BaseProduct> products = BookingStreamHelper.getBaseProductsStream((BookingFile)((BookingFile)bookingFile.getEntity())).filter(p -> GeneralProductHelper.getStatus((BaseProduct)p) == ProductStatus.SELL).filter(p -> !oldUids.contains(p.getUid())).collect(Collectors.toList());
        if (!products.isEmpty()) {
            products.forEach(p -> {
                String message = "";
                if (!applicableClasses.contains(p.getClass())) {
                    message = L10nResourcesManager.getStr((String)"NEW_SALE", (Object[])new Object[]{((BookingFile)bookingFile.getEntity()).getNumber(), String.join((CharSequence)", ", GeneralProductHelper.getHandler((BaseProduct)p).getProductNumbers(p))});
                } else {
                    ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)p);
                    String orderNumber = ((BookingFile)bookingFile.getEntity()).getNumber();
                    String productNumber = String.join((CharSequence)",", handler.getProductNumbers(p));
                    String productType = handler.getProductType(p).toString();
                    String recordLocator = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)p.getReservation());
                    AtomicReference<String> supplier = new AtomicReference<String>("");
                    if (p instanceof Product) {
                        Optional.ofNullable(AirProductHelper.getSupplier((Product)((Product)p))).ifPresent(s -> supplier.set(s.getCaption()));
                    } else if (p instanceof RailwayProduct) {
                        Optional.ofNullable(RailwayProductHelper.getSupplier((BaseProduct)p)).ifPresent(s -> supplier.set(s.getCaption()));
                    } else if (p instanceof HotelProduct) {
                        Optional.ofNullable(HotelProductHelper.getSupplier((HotelProduct)((HotelProduct)p))).ifPresent(s -> supplier.set(s.getCaption()));
                    } else if (p instanceof Transfer) {
                        Optional.ofNullable(TransferHelper.getSupplier((Transfer)((Transfer)p))).ifPresent(s -> supplier.set(s.getCaption()));
                    } else if (p instanceof AeroexpressTicket) {
                        Optional.ofNullable(AeroExpressHelper.getSupplier((AeroexpressTicket)((AeroexpressTicket)p))).ifPresent(s -> supplier.set(s.getCaption()));
                    }
                    message = L10nResourcesManager.getStr((String)"NEW_SALE_SD", (Object[])new Object[]{orderNumber, productNumber, productType, recordLocator, supplier.get()});
                }
                SDHelper.sendEvent("203", bookingFile, Collections.singletonList(p), message);
            });
        }
    }

    private void reservationError(EntityContainer<BookingFile> bookingFile, BookingFile oldBookingFile) {
        ArrayList oldUids = oldBookingFile == null ? new ArrayList() : oldBookingFile.getReservations().stream().filter(r -> r.getStatus() == ReservationStatus.ERROR).map(BaseIdentity::getUid).collect(Collectors.toList());
        List<BaseProduct> products = ((BookingFile)bookingFile.getEntity()).getReservations().stream().filter(r -> r.getStatus() == ReservationStatus.ERROR).filter(r -> !oldUids.contains(r.getUid())).flatMap(r -> r.getProducts().stream()).collect(Collectors.toList());
        List numbers = ((BookingFile)bookingFile.getEntity()).getReservations().stream().filter(r -> r.getStatus() == ReservationStatus.ERROR).filter(r -> !oldUids.contains(r.getUid())).map(CommonReservationGdsNameInfoHelper::getDisplayedRecordLocator).collect(Collectors.toList());
        if (!numbers.isEmpty()) {
            SDHelper.sendEvent("204", bookingFile, products, L10nResourcesManager.getStr((String)"RESERVATION_ERROR", (Object[])new Object[]{((BookingFile)bookingFile.getEntity()).getNumber(), String.join((CharSequence)", ", numbers)}));
        }
    }

    private void reject(EntityContainer<BookingFile> bookingFile, BookingFile oldBookingFile) {
        ArrayList oldUids = oldBookingFile == null ? new ArrayList() : BookingStreamHelper.getBaseProductsStream((BookingFile)oldBookingFile).filter(p -> GeneralProductHelper.getStatus((BaseProduct)p) == ProductStatus.REJECT).map(BaseIdentity::getUid).collect(Collectors.toList());
        List<BaseProduct> products = BookingStreamHelper.getBaseProductsStream((BookingFile)((BookingFile)bookingFile.getEntity())).filter(p -> GeneralProductHelper.getStatus((BaseProduct)p) == ProductStatus.REJECT).filter(p -> !oldUids.contains(p.getUid())).collect(Collectors.toList());
        List numbers = products.stream().flatMap(p -> GeneralProductHelper.getHandler((BaseProduct)p).getProductNumbers(p).stream()).collect(Collectors.toList());
        if (!numbers.isEmpty()) {
            SDHelper.sendEvent("205", bookingFile, products, L10nResourcesManager.getStr((String)"REJECT", (Object[])new Object[]{((BookingFile)bookingFile.getEntity()).getNumber(), String.join((CharSequence)", ", numbers)}));
        }
    }

    private void voidRefund(EntityContainer<BookingFile> bookingFile, BookingFile oldBookingFile) {
        ArrayList oldUidsRefund = oldBookingFile == null ? new ArrayList() : BookingStreamHelper.getBaseProductsStream((BookingFile)oldBookingFile).filter(p -> GeneralProductHelper.getStatus((BaseProduct)p) == ProductStatus.REFUND).map(BaseIdentity::getUid).collect(Collectors.toList());
        List<BaseProduct> products = BookingStreamHelper.getBaseProductsStream((BookingFile)((BookingFile)bookingFile.getEntity())).filter(p -> GeneralProductHelper.getStatus((BaseProduct)p) == ProductStatus.REFUND).filter(p -> !oldUidsRefund.contains(p.getUid())).collect(Collectors.toList());
        List numbersRefund = products.stream().flatMap(p -> GeneralProductHelper.getHandler((BaseProduct)p).getProductNumbers(p).stream()).collect(Collectors.toList());
        ArrayList oldUidsVoid = oldBookingFile == null ? new ArrayList() : BookingStreamHelper.getBaseProductsStream((BookingFile)oldBookingFile).filter(p -> ProductStatusHandler.getAllVoidStatuses().contains(GeneralProductHelper.getStatus((BaseProduct)p))).map(BaseIdentity::getUid).collect(Collectors.toList());
        List productsVoid = BookingStreamHelper.getBaseProductsStream((BookingFile)((BookingFile)bookingFile.getEntity())).filter(p -> ProductStatusHandler.getAllVoidStatuses().contains(GeneralProductHelper.getStatus((BaseProduct)p))).filter(p -> !oldUidsVoid.contains(p.getUid())).collect(Collectors.toList());
        List numbersVoid = productsVoid.stream().flatMap(p -> GeneralProductHelper.getHandler((BaseProduct)p).getProductNumbers(p).stream()).collect(Collectors.toList());
        if (!numbersRefund.isEmpty() || !numbersVoid.isEmpty()) {
            products.addAll(productsVoid);
            String message = numbersRefund.isEmpty() ? L10nResourcesManager.getStr((String)"VOID", (Object[])new Object[]{((BookingFile)bookingFile.getEntity()).getNumber(), String.join((CharSequence)", ", numbersVoid)}) : L10nResourcesManager.getStr((String)"REFUND", (Object[])new Object[]{((BookingFile)bookingFile.getEntity()).getNumber(), String.join((CharSequence)", ", numbersRefund)}) + (numbersVoid.isEmpty() ? "" : "\n" + L10nResourcesManager.getStr((String)"VOID", (Object[])new Object[]{((BookingFile)bookingFile.getEntity()).getNumber(), String.join((CharSequence)", ", numbersVoid)}));
            SDHelper.sendEvent("206", bookingFile, products, message);
        }
    }

    private void cancelAviaRailwayBeforeIssue(EntityContainer<BookingFile> bookingFile, BookingFile oldBookingFile) {
        ArrayList oldUids = oldBookingFile == null ? new ArrayList() : BookingStreamHelper.getBaseProductsStream((BookingFile)oldBookingFile).filter(p -> !(!(p instanceof Product) && !(p instanceof RailwayProduct) || GeneralProductHelper.getStatus((BaseProduct)p) != ProductStatus.INTENTION && GeneralProductHelper.getStatus((BaseProduct)p) != ProductStatus.BOOKING)).map(BaseIdentity::getUid).collect(Collectors.toList());
        List<BaseProduct> products = BookingStreamHelper.getBaseProductsStream((BookingFile)((BookingFile)bookingFile.getEntity())).filter(p -> !(!(p instanceof Product) && !(p instanceof RailwayProduct) || GeneralProductHelper.getStatus((BaseProduct)p) != ProductStatus.INTENTION && GeneralProductHelper.getStatus((BaseProduct)p) != ProductStatus.BOOKING)).filter(p -> !oldUids.contains(p.getUid())).collect(Collectors.toList());
        List numbers = products.stream().flatMap(p -> GeneralProductHelper.getHandler((BaseProduct)p).getProductNumbers(p).stream()).collect(Collectors.toList());
        if (!numbers.isEmpty()) {
            SDHelper.sendEvent("207", bookingFile, products, L10nResourcesManager.getStr((String)"CANCEL_AVIA_RW", (Object[])new Object[]{((BookingFile)bookingFile.getEntity()).getNumber(), String.join((CharSequence)", ", numbers)}));
        }
    }

    private void priceChange(EntityContainer<BookingFile> bookingFile, BookingFile oldBookingFile) {
        if (oldBookingFile == null) {
            return;
        }
        Map<String, BigDecimal> newPriceMap = BookingHelper.getProducts((BookingFile)((BookingFile)bookingFile.getEntity())).stream().collect(Collectors.toMap(BaseIdentity::getUid, p -> XtripPriceStructureHelper.calculatePriceStructure((BaseProduct)p, (boolean)true).getTotal()));
        Map<String, BigDecimal> oldPriceMap = BookingHelper.getProducts((BookingFile)((BookingFile)bookingFile.getEntity())).stream().collect(Collectors.toMap(BaseIdentity::getUid, p -> XtripPriceStructureHelper.calculatePriceStructure((BaseProduct)p, (boolean)true).getTotal()));
        List uids = newPriceMap.entrySet().stream().filter(e -> !MiscUtil.equals(e.getValue(), oldPriceMap.get(e.getKey()))).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!uids.isEmpty()) {
            List products = BookingHelper.getProducts((BookingFile)((BookingFile)bookingFile.getEntity())).stream().filter(p -> uids.contains(p.getUid())).collect(Collectors.toList());
            SDHelper.sendEvent("208", bookingFile, L10nResourcesManager.getStr((String)"PRICE_CHANGE", (Object[])new Object[]{((BookingFile)bookingFile.getEntity()).getNumber(), products.stream().flatMap(p -> GeneralProductHelper.getHandler((BaseProduct)p).getProductNumbers(p).stream()).collect(Collectors.joining(", "))}));
        }
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    static {
        applicableClasses.add(Product.class);
        applicableClasses.add(RailwayProduct.class);
        applicableClasses.add(HotelProduct.class);
        applicableClasses.add(Transfer.class);
        applicableClasses.add(AeroexpressTicket.class);
    }
}

