/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.sd.storage;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ExternalSystem;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.BaseIssue;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.Post;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.sd.SDHelper;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDCorrespondenceInterceptor
implements EntityInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SDCorrespondenceInterceptor.class);

    public double getPriority() {
        return Double.MIN_VALUE;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!BaseIssue.class.isAssignableFrom(data.getEntityType())) {
            return;
        }
        if (TextUtil.equals((String)data.getVersionInfo().getDataSource(), (String)"ext-api", (boolean)false)) {
            return;
        }
        if (SDHelper.isDisabled()) {
            return;
        }
        if (SDHelper.isInvalid()) {
            log.warn("Service desk settings are not filled");
            return;
        }
        DictionaryReference<ExternalSystem> settingSystem = SDHelper.getExternalSystem();
        if (settingSystem == null) {
            log.warn("Service desk settings are enabled but external system is not set");
            return;
        }
        EntityContainer<?> issueCtr = data;
        if (((BaseIssue)issueCtr.getEntity()).getBooking() == null) {
            return;
        }
        EntityContainer bookingFileCtr = EntityStorage.get().resolve(((BaseIssue)issueCtr.getEntity()).getBooking());
        if (bookingFileCtr == null) {
            log.warn("Failed to resolve booking file " + ((BaseIssue)issueCtr.getEntity()).getBooking().getUid());
            return;
        }
        EntityContainer oldIssueCtr = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
        BaseIssue oldIssue = oldIssueCtr == null ? null : (BaseIssue)oldIssueCtr.getEntity();
        this.addComment((BaseIssue)issueCtr.getEntity(), oldIssue, (EntityContainer<BookingFile>)bookingFileCtr);
    }

    private void addComment(BaseIssue issue, BaseIssue oldIssue, EntityContainer<BookingFile> bookingFile) {
        List<Post> posts = issue.getPosts().stream().skip(oldIssue == null ? 0L : (long)oldIssue.getPosts().size()).collect(Collectors.toList());
        if (!posts.isEmpty()) {
            SDHelper.sendComment(posts, bookingFile);
        }
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }
}

