/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.sd.storage;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ExternalSystem;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.FilledTemplateDocument;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.sd.SDHelper;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDDocumentInterceptor
implements EntityInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SDDocumentInterceptor.class);
    private static final Set<DocumentType> acceptableTypes = EnumSet.of(DocumentType.VOUCHER, DocumentType.RECEIPT, DocumentType.TRAVELDOCUMENT, DocumentType.SPECIAL_TRAVELDOCUMENT);

    public double getPriority() {
        return Double.MIN_VALUE;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!this.isApplicable(data)) {
            return;
        }
        EntityContainer oldDocCtr = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
        if (oldDocCtr != null) {
            return;
        }
        this.addRemoveDocument(data, "DOCUMENT_ADD");
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!this.isApplicable(data)) {
            return;
        }
        this.addRemoveDocument(data, "DOCUMENT_REMOVE");
    }

    private boolean isApplicable(EntityContainer<?> data) {
        if (data == null) {
            return false;
        }
        if (!(FilledTemplateDocument.class.equals((Object)data.getEntityType()) || Document.class.equals((Object)data.getEntityType()) && acceptableTypes.contains(((Document)data.getEntity()).getType()))) {
            return false;
        }
        if (SDHelper.isDisabled()) {
            return false;
        }
        if (SDHelper.isInvalid()) {
            log.warn("Service desk settings are not filled");
            return false;
        }
        DictionaryReference<ExternalSystem> settingSystem = SDHelper.getExternalSystem();
        if (settingSystem == null) {
            log.warn("Service desk settings are enabled but external system is not set");
            return false;
        }
        return true;
    }

    private void addRemoveDocument(EntityContainer<?> data, String message) {
        Thread thread = new Thread(() -> {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            EntityContainer docCtr = data;
            DictionaryReference<ExternalSystem> settingSystem = SDHelper.getExternalSystem();
            if (!(((BaseFileDocument)docCtr.getEntity()).getOwner() != null && ((BaseFileDocument)docCtr.getEntity()).getOwner().getType().equals(BookingFile.class) || !((BaseFileDocument)docCtr.getEntity()).getOwners().isEmpty() && !((BaseFileDocument)docCtr.getEntity()).getOwners().stream().noneMatch(r -> r.getType().equals(BookingFile.class)))) {
                return;
            }
            List<Object> list = ((BaseFileDocument)docCtr.getEntity()).getOwner() != null && ((BaseFileDocument)docCtr.getEntity()).getOwner().getType().equals(BookingFile.class) ? Collections.singletonList(((BaseFileDocument)docCtr.getEntity()).getOwner()) : ((BaseFileDocument)docCtr.getEntity()).getOwners().stream().filter(r -> r.getType().equals(BookingFile.class)).map(r -> r).collect(Collectors.toList());
            list.forEach(ref -> {
                EntityContainer bookingFileCtr = EntityStorage.get().resolve(ref);
                if (bookingFileCtr == null) {
                    log.warn("Failed to resolve booking file " + ref.getUid());
                    return;
                }
                String orderNumber = ((BookingFile)bookingFileCtr.getEntity()).getNumber();
                String productNumber = "";
                String recordLocator = "";
                String type = docCtr.getEntity() instanceof Document ? ((Document)docCtr.getEntity()).getType().toString() : "";
                String name = ((BaseFileDocument)docCtr.getEntity()).getTitle();
                String description = "";
                String date = new SimpleDateFormat("dd.MM.yyyy").format(((BaseFileDocument)docCtr.getEntity()).getCreated());
                String fio = "";
                if (((BaseFileDocument)docCtr.getEntity()).getNavigationKey() != null) {
                    BaseProduct product = BookingHelper.findProductByUid((String)((BaseFileDocument)docCtr.getEntity()).getNavigationKey(), (BookingFile)((BookingFile)bookingFileCtr.getEntity()));
                    if (product != null) {
                        ProductHandler handler = ProductHandler.of((BaseProduct)product);
                        productNumber = String.join((CharSequence)",", handler.getProductNumbers(product));
                        recordLocator = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation());
                        description = handler.getDefaultTravelSubject().toString();
                        fio = handler.getTravellers(product).stream().map(Traveller::getName).filter(Objects::nonNull).collect(Collectors.joining(","));
                    } else {
                        Reservation reservation = BookingHelper.findReservationByUid((BookingFile)((BookingFile)bookingFileCtr.getEntity()), (String)((BaseFileDocument)docCtr.getEntity()).getNavigationKey());
                        if (reservation != null) {
                            recordLocator = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation);
                        }
                    }
                }
                SDHelper.sendEvent("201", (EntityContainer<BookingFile>)bookingFileCtr, L10nResourcesManager.getStr((String)message, (Object[])new Object[]{orderNumber, productNumber, recordLocator, type, name, description, date, fio}));
            });
        });
        thread.start();
    }
}

