/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.statistic.storage;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.gds.sabre.CostCodesHelper;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.statistic.helpers.CommonStatisticsHelper;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import java.util.Collection;
import java.util.Objects;

public class StatisticBookingFileContainerInterceptor
implements EntityInterceptor {
    public double getPriority() {
        return 3.0;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        BookingFile bookingFile = (BookingFile)data.getEntity();
        bookingFile.getReservations().stream().flatMap(reservation -> reservation.getProducts().stream()).map(product -> {
            ProductHandler handler = ProductHandler.of((BaseProduct)product);
            return handler.getStatisticalData(product);
        }).filter(Objects::nonNull).map(StatisticsHelper::getAllCostCodes).flatMap(Collection::stream).filter(Objects::nonNull).map(CostCode::getValue).filter(Objects::nonNull).filter(CostCodesHelper::isCostCodeContainsUnsupportedSymbols).findFirst().ifPresent(value -> {
            throw Xeption.forEndUser((String)Messages.UnsupportedSymbolsInUdidValue, (Object[])new Object[]{CostCodesHelper.UNSUPPORTED_SYMBOLS, value});
        });
        CommonStatisticsHelper.fillSalesDeeps((BookingFile)bookingFile);
        BookingStreamHelper.getProductsStream((BookingFile)bookingFile, Product.class).forEach(CommonStatisticsHelper::fillFlightDuration);
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }
}

