/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.statistic.storage;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class StatisticOrganizationInterceptor
implements EntityInterceptor {
    public double getPriority() {
        return -Math.pow(10.0, 100.0);
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (Organization.class.equals((Object)data.getEntityType())) {
            this.checkCostCodeCategories(data);
        }
    }

    private void checkCostCodeCategories(EntityContainer<?> data) {
        Organization org = (Organization)data.getEntity();
        List categories = org.getCostCodeProperties().stream().map(CostCodeProperties::getCategory).collect(Collectors.toList());
        String cccs = categories.stream().filter(ccc -> Collections.frequency(categories, ccc) > 1).distinct().map(DictionaryReference::getCaption).collect(Collectors.joining(", "));
        if (TextUtil.nonBlank((String)cccs)) {
            throw Xeption.forEndUser((String)Messages.OrganizationCostCodeCategoryDuplicate, (Object[])new Object[]{org.getShortName(), cccs});
        }
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }
}

