/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.ibus;

import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.transfers.AdditionalService;
import com.gridnine.xtrip.common.model.dict.CarClass;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.transfers.RentParams;
import com.gridnine.xtrip.common.transfers.GdsPlaceInfo;
import com.gridnine.xtrip.common.transfers.model.BaseTransferGdsAccount;
import com.gridnine.xtrip.server.transfers.GdsCarClass;
import com.gridnine.xtrip.server.transfers.SearchGdsResponse;
import com.gridnine.xtrip.server.transfers.SubaddressInfo;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Pattern;

public class TransfersHelper {
    private static final Pattern PHONE_PATTERN = Pattern.compile("^([\\+\\(\\)\\- ]*\\d){7,15}$");

    public static SearchGdsResponse createSearchResponseItem(GetSearchResponseProvider provider) {
        SearchGdsResponse response = new SearchGdsResponse();
        response.setGdsAccount(provider.getGdsAccount());
        response.setSubaddressInfo(new SubaddressInfo());
        response.getSubaddressInfo().setAllowableSubaddresses(provider.getAllowableSubaddressesCount());
        response.getSubaddressInfo().setPriceSubaddress(provider.getSubaddressPrice());
        response.setCancellationNoPenaltyHours(Integer.valueOf(provider.getCancellationNoPenaltyHours()));
        response.setCarClass(TransfersHelper.buildGdsCarClass(provider));
        response.setPrice(provider.getPrice());
        response.setGdsTripId(provider.getGdsTripId());
        response.setBlankOwner(provider.getBlankOwner());
        response.setSalesPoint(provider.getSalesPoint());
        response.setStartPlace(provider.getStartPlace());
        response.setEndPlace(provider.getEndPlace());
        response.getAvailableAdditionalServices().addAll(provider.getAvailableAdditionalServices());
        response.setRentParams(provider.getRentParams());
        response.setFlexibleTariff(provider.isFlexibleTariff());
        response.setFlexibleTariffAgreement(provider.isFlexibleTariffAgreement());
        return response;
    }

    public static String getAgentEmail(SalesContext salesContext) {
        EntityReference agent = salesContext.getAgent();
        EntityContainer customerCtr = EntityStorage.get().resolve(agent);
        Collection emailCommunications = ProfileHelper.filterCommunications((Collection)((Person)customerCtr.getEntity()).getCommunications(), EnumSet.of(CommunicationType.EMAIL));
        if (emailCommunications.isEmpty()) {
            return null;
        }
        return ((PersonCommunication)emailCommunications.iterator().next()).getSense();
    }

    public static GdsCarClass buildGdsCarClass(GetSearchResponseProvider provider) {
        GdsCarClass gdsCarClass = new GdsCarClass();
        gdsCarClass.setCarClassDict(provider.getCarClassRef());
        gdsCarClass.setCapacity(Integer.valueOf(provider.getCapacity()));
        gdsCarClass.setModels(provider.getModels());
        gdsCarClass.setImageUrl(provider.getImageUrl());
        return gdsCarClass;
    }

    public static boolean validatePhoneNumber(Communication communicationPhone) {
        String phoneNumber = ProfileHelper.buildFullPhoneNumber((Communication)communicationPhone);
        return PHONE_PATTERN.matcher(phoneNumber).matches();
    }

    public static interface GetSearchResponseProvider {
        public EntityReference<SalesPoint> getSalesPoint();

        public EntityReference<? extends BaseTransferGdsAccount> getGdsAccount();

        public int getCancellationNoPenaltyHours();

        public GdsPlaceInfo getStartPlace();

        public GdsPlaceInfo getEndPlace();

        public DictionaryReference<CarClass> getCarClassRef();

        public int getCapacity();

        public String getModels();

        public BigDecimal getPrice();

        public int getAllowableSubaddressesCount();

        public BigDecimal getSubaddressPrice();

        public Integer getGdsTripId();

        public String getImageUrl();

        public EntityReference<Organization> getBlankOwner();

        public List<AdditionalService> getAvailableAdditionalServices();

        public RentParams getRentParams();

        public boolean isFlexibleTariff();

        public boolean isFlexibleTariffAgreement();

        public String getCurrency();
    }
}

