/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.ibus.createBooking;

import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.transfers.TransfersValidationMessages;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.List;

public class FullTravellerValidator {
    public static void validate(Traveller traveller) {
        if (TextUtil.isBlank((String)traveller.getPassport().getFirstName())) {
            traveller.getPassport().getValidationContext().getFirstNameValidationMessages().add(TransfersValidationMessages.getMissingRequiredField());
        }
        if (TextUtil.isBlank((String)traveller.getPassport().getLastName())) {
            traveller.getPassport().getValidationContext().getLastNameValidationMessages().add(TransfersValidationMessages.getMissingRequiredField());
        }
        FullTravellerValidator.validateEmail(traveller);
    }

    private static void validateEmail(Traveller traveller) {
        Communication emailCommunication = ProfileHelper.getEmailCommunication((List)traveller.getCommunications());
        if (emailCommunication != null) {
            if (TextUtil.isBlank((String)emailCommunication.getSense())) {
                emailCommunication.getValidationContext().getSenseValidationMessages().add(TransfersValidationMessages.getMissingRequiredField());
            } else if (!TextUtil.isValidEmailAddress((String)emailCommunication.getSense())) {
                emailCommunication.getValidationContext().getSenseValidationMessages().add(TransfersValidationMessages.getEmailFormatError());
            }
        }
    }
}

