/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.ibus.createBooking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.transfer.TransferHelper;
import com.gridnine.xtrip.common.model.booking.transfers.AdditionalService;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.booking.transfers.TransferPointMiscData;
import com.gridnine.xtrip.common.model.dict.CarClass;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.transfers.TransferReservationCreationParameters;
import com.gridnine.xtrip.common.transfers.TripPoint;
import com.gridnine.xtrip.common.transfers.model.BaseTransferGdsAccount;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.transfers.GdsCarClass;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TransferReservationBuilderProcessor
extends BaseProcessor {
    private boolean isFake;

    public void configure(Map<String, String> parameters) {
        this.isFake = Boolean.parseBoolean(IbusConfigurationHelper.getOptionalParameter(parameters, (String)"fake", (String)"false"));
    }

    public void process(MessageContext ctx) throws Exception {
        TransferReservationCreationParameters parameters = (TransferReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        Reservation reservation = this.createReservation(parameters, salesContext);
        this.createTransferProduct(parameters, reservation, salesContext, travellers);
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)reservation);
    }

    private void createTransferProduct(TransferReservationCreationParameters parameters, Reservation reservation, SalesContext salesContext, Collection<Traveller> travellers) {
        EntityContainer accountCtr = EntityStorage.get().resolve(parameters.getGdsAccount());
        BaseTransferGdsAccount account = (BaseTransferGdsAccount)accountCtr.getEntity();
        Transfer product = new Transfer();
        reservation.getProducts().add(product);
        product.setStatus(ProductStatus.BOOKING);
        product.setTicketType(TicketType.OWN);
        product.setTransferType(parameters.getTransferType());
        product.setNotes(parameters.getNotes());
        product.setPassengersCount(parameters.getPassengersCount());
        product.setContractRulesApplied(false);
        product.getTravellers().addAll(travellers);
        product.setReservation(reservation);
        product.setSalesPoint(salesContext.getSalesPoint());
        product.setBlankOwner(parameters.getTripDetails().getSearchGdsResponse().getBlankOwner());
        TransferHelper.setSupplier((Transfer)product, (EntityReference)account.getSupplier());
        TransferHelper.setAgency((Transfer)product, (EntityReference)salesContext.getAgency());
        TransferHelper.setSubagency((Transfer)product, (EntityReference)salesContext.getSubagency());
        product.setAgent(salesContext.getAgent());
        TransferReservationBuilderProcessor.setEquivalentSum(product, this.calculateEquivalentPrice(parameters));
        product.setComments(parameters.getNotes());
        if (TextUtil.nonBlank((String)parameters.getTableCaption())) {
            product.setTableCaption(parameters.getTableCaption());
        }
        product.setPassengersCount(parameters.getPassengersCount());
        GdsCarClass gdsCarClass = parameters.getTripDetails().getSearchGdsResponse().getCarClass();
        CarClass carClass = (CarClass)DictionaryCache.get().resolveReference(gdsCarClass.getCarClassDict());
        product.setCarClass((DictionaryReference)carClass.toReference());
        product.getAddInfo().setCarModels(gdsCarClass.getModels());
        product.getAddInfo().setCarCapacity(gdsCarClass.getCapacity());
        product.getAddInfo().setCarImageUrl(gdsCarClass.getImageUrl());
        this.setDates(parameters, product);
        this.setAddresses(parameters, product);
        this.addSubaddresses(parameters, product);
        product.setCancellationNoPenaltyHours(parameters.getTripDetails().getCancellationNoPenaltyHours());
        product.getAdditionalServices().addAll(parameters.getTripDetails().getAdditionalServices());
        product.setFlexibleTariff(parameters.getTripDetails().isFlexibleTariff());
        product.setFlexibleTariffAgreement(parameters.getTripDetails().isFlexibleTariffAgreement());
        product.setAdultCount(Integer.valueOf(parameters.getTripDetails().getAdultCount()));
        product.setChildCount(Integer.valueOf(parameters.getTripDetails().getChildCount()));
        GeneralProductHelper.updateFops((BaseProduct)product);
    }

    protected BigDecimal calculateEquivalentPrice(TransferReservationCreationParameters parameters) {
        BigDecimal price = parameters.getTripDetails().getSearchGdsResponse().getPrice();
        BigDecimal subadressPrice = parameters.getTripDetails().getSearchGdsResponse().getSubaddressInfo().getPriceSubaddress().multiply(BigDecimal.valueOf(parameters.getTripDetails().getSubAddresses().size()));
        BigDecimal excludedDefaultPrice = parameters.getTripDetails().getSearchGdsResponse().getAvailableAdditionalServices().stream().filter(AdditionalService::isDefaultInclude).filter(defaultService -> !parameters.getTripDetails().getAdditionalServices().contains(defaultService)).map(AdditionalService::getPrice).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        return price.add(subadressPrice).subtract(excludedDefaultPrice);
    }

    private void addSubaddresses(TransferReservationCreationParameters parameters, Transfer product) {
        parameters.getTripDetails().getSubAddresses().forEach(subaddress -> {
            product.getSubAddresses().add(subaddress.getAddress());
            product.getSubAddressesLocations().add(subaddress.getLocation());
        });
    }

    private void setDates(TransferReservationCreationParameters parameters, Transfer product) {
        product.setIssueDate(new Date());
        Optional.ofNullable(parameters.getTripDetails().getStart().getTime()).ifPresent(arg_0 -> ((Transfer)product).setStartDate(arg_0));
        Optional.ofNullable(parameters.getTripDetails().getEnd().getTime()).ifPresent(arg_0 -> ((Transfer)product).setEndDate(arg_0));
    }

    private void setAddresses(TransferReservationCreationParameters parameters, Transfer product) {
        TripPoint start = parameters.getTripDetails().getStart();
        product.setStartAddress(start.getAddress());
        product.setStartPlaceLocation(start.getLocation());
        product.setStartMiscData(this.buildMiscData(start));
        product.setStartType(parameters.getTripDetails().getSearchGdsResponse().getStartPlace().getType());
        TripPoint end = parameters.getTripDetails().getEnd();
        product.setEndAddress(end.getAddress());
        product.setEndPlaceLocation(end.getLocation());
        product.setEndMiscData(this.buildMiscData(end));
        product.setEndType(parameters.getTripDetails().getSearchGdsResponse().getEndPlace().getType());
    }

    private TransferPointMiscData buildMiscData(TripPoint point) {
        TransferPointMiscData result = new TransferPointMiscData();
        result.setTerminal(point.getTerminalNumber());
        result.setFlightNumber(point.getFlightNumber());
        result.setTrainNumber(point.getTrainNumber());
        result.setTrainCarriageNumber(point.getTrainCarriageNumber());
        return result;
    }

    private Reservation createReservation(TransferReservationCreationParameters parameters, SalesContext salesContext) {
        Reservation reservation = new Reservation();
        reservation.getGdsNameInfo().setOnlineGdsAccount(parameters.getGdsAccount());
        if (this.isFake) {
            reservation.getGdsNameInfo().setRulesGdsName(((BaseGdsAccount)EntityStorage.get().resolve(parameters.getGdsAccount()).getEntity()).getGds());
        }
        reservation.setResDate(new Date());
        reservation.setType(ReservationType.IBE);
        reservation.setSubagency(salesContext.getSubagency());
        reservation.setSalesPoint(salesContext.getSalesPoint());
        reservation.setBookingAgent(salesContext.getAgent());
        return reservation;
    }

    public static void setEquivalentSum(Transfer transfer, BigDecimal value) {
        if (value == null) {
            transfer.setEquivalentFare(null);
        }
        transfer.setEquivalentFare(MoneyHelper.buildMoney((BigDecimal)value, (String)DictHelper.getEquivCurrency()));
    }
}

