/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.ibus.createBooking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.BaseReservationCreationParameters;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.transfers.PlaceType;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.transfers.TransferReservationCreationParameters;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.transfers.ContactPerson;
import com.gridnine.xtrip.common.transfers.GdsPlaceInfo;
import com.gridnine.xtrip.common.transfers.TransfersValidationMessages;
import com.gridnine.xtrip.common.transfers.TripPoint;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.transfers.ibus.TransfersHelper;
import com.gridnine.xtrip.server.transfers.ibus.createBooking.FullTravellerValidator;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public class TransfersCreateReservationValidationProcessor
extends BaseProcessor {
    private static final int MAX_CONTACT_PERSON_NAME_LENGTH = 100;

    public void process(MessageContext ctx) throws Exception {
        TransferReservationCreationParameters parameters = (TransferReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Collection parametersCollection = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATIONS_CREATION_PARAMETERS);
        List travellers = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        this.validatePassengerData(parameters, travellers);
        this.validateContactPerson(parameters);
        this.validateRoundTrip(parameters, parametersCollection);
        this.validateSalesContext(salesContext);
        GdsPlaceInfo startPlace = parameters.getTripDetails().getSearchGdsResponse().getStartPlace();
        TripPoint startPoint = parameters.getTripDetails().getStart();
        if (startPlace.getType().equals((Object)PlaceType.RAILWAY_STATION)) {
            this.validateTrainParameters(startPoint);
        } else if (startPlace.getType().equals((Object)PlaceType.AIRPORT)) {
            this.validateFlightParameters(startPoint, !startPlace.getTerminal().isEmpty());
        }
    }

    private void validateSalesContext(SalesContext sc) {
        String agentEmail = TransfersHelper.getAgentEmail(sc);
        if (TextUtil.isBlank((String)agentEmail)) {
            throw Xeption.forEndUser((String)"\u0412 \u0432\u0430\u0448\u0435\u043c \u043f\u0440\u043e\u0444\u0438\u043b\u0435 \u043d\u0430 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d email, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u0435\u043d \u0434\u043b\u044f \u0432\u044b\u043f\u0438\u0441\u043a\u0438 \u0437\u0430\u043a\u0430\u0437\u0430", (Object[])new Object[0]);
        }
    }

    private void validateRoundTrip(TransferReservationCreationParameters backParameters, Collection<BaseReservationCreationParameters> parametersCollection) {
        TransferReservationCreationParameters toParams;
        if (parametersCollection.size() > 1 && (toParams = (TransferReservationCreationParameters)parametersCollection.iterator().next()) != backParameters) {
            this.validateBackLeg(backParameters, toParams);
        }
    }

    private void validateBackLeg(TransferReservationCreationParameters backParameters, TransferReservationCreationParameters toParams) {
        Date backStart = backParameters.getTripDetails().getStart().getTime();
        Date toStart = toParams.getTripDetails().getStart().getTime();
        if (backStart != null && toStart != null && (backStart.before(toStart) || backStart.equals(toStart))) {
            backParameters.getTripDetails().getStart().getValidationContext().getTimeValidationMessages().add(TransfersValidationMessages.getIncorrectDateArrivalDepartures());
        }
    }

    private void validatePassengerData(TransferReservationCreationParameters params, List<Traveller> travellers) {
        travellers.forEach(FullTravellerValidator::validate);
        this.validatePassengersCount(params);
    }

    private void validatePassengersCount(TransferReservationCreationParameters params) {
        if (params.getPassengersCount() == null || params.getPassengersCount() < 1) {
            params.getValidationContext().getPassengersCountValidationMessages().add(TransfersValidationMessages.getMissingRequiredField());
        } else if (params.getPassengersCount() > params.getTripDetails().getSearchGdsResponse().getCarClass().getCapacity()) {
            params.getValidationContext().getPassengersCountValidationMessages().add(TransfersValidationMessages.getCapacityExceeded());
        }
    }

    private void validateContactPerson(TransferReservationCreationParameters parameters) {
        if (parameters.getCustomer() == null) {
            parameters.getValidationContext().getPassengersCountValidationMessages().add(TransfersValidationMessages.getMissingRequiredField());
        }
    }

    private void validateContactPerson(ContactPerson contactPerson) {
        String name = contactPerson.getName();
        if (TextUtil.isBlank((String)name)) {
            contactPerson.getValidationContext().getNameValidationMessages().add(TransfersValidationMessages.getMissingRequiredField());
        } else if (name.length() > 100) {
            contactPerson.getValidationContext().getNameValidationMessages().add(TransfersValidationMessages.getNameLengthExceeded((int)100));
        }
        if (contactPerson.getPhone() != null) {
            this.validatePhone(contactPerson.getPhone());
        } else {
            contactPerson.getValidationContext().getPhoneValidationMessages().add(TransfersValidationMessages.getMissingRequiredField());
        }
    }

    private void validatePhone(Communication phone) {
        if (TextUtil.isBlank((String)phone.getCountryCode())) {
            phone.getValidationContext().getCountryCodeValidationMessages().add(TransfersValidationMessages.getMissingRequiredField());
        }
        if (TextUtil.isBlank((String)phone.getCityCode())) {
            phone.getValidationContext().getCityCodeValidationMessages().add(TransfersValidationMessages.getMissingRequiredField());
        }
        if (TextUtil.isBlank((String)phone.getSense())) {
            phone.getValidationContext().getSenseValidationMessages().add(TransfersValidationMessages.getMissingRequiredField());
        }
        if (!TransfersHelper.validatePhoneNumber(phone)) {
            phone.getValidationContext().getSenseValidationMessages().add(TransfersValidationMessages.getPhoneFormatError());
        }
    }

    private void validateTrainParameters(TripPoint startPoint) {
        TransfersCreateReservationValidationProcessor.validate(startPoint, TripPoint::getTrainNumber, str -> str.length() > 10, TripPoint.TripPointValidationContext::getTrainNumberValidationMessages, TransfersValidationMessages.getIncorrectTrainNumber());
        TransfersCreateReservationValidationProcessor.validate(startPoint, TripPoint::getTrainCarriageNumber, str -> str.length() > 5, TripPoint.TripPointValidationContext::getTrainCarriageNumberValidationMessages, TransfersValidationMessages.getIncorrectTrainCarriageNumber());
    }

    private void validateFlightParameters(TripPoint startPoint, boolean isTerminalMandatory) {
        if (isTerminalMandatory) {
            TransfersCreateReservationValidationProcessor.validate(startPoint, TripPoint::getTerminalNumber, str -> str.length() > 15, TripPoint.TripPointValidationContext::getTerminalNumberValidationMessages, TransfersValidationMessages.getIncorrectTerminalNumber());
        }
        TransfersCreateReservationValidationProcessor.validate(startPoint, TripPoint::getFlightNumber, str -> str.length() > 10, TripPoint.TripPointValidationContext::getFlightNumberValidationMessages, TransfersValidationMessages.getIncorrectFlightNumber());
    }

    private static void validate(TripPoint tripPoint, Function<TripPoint, String> tripPointStringFunction, Predicate<String> predicate, Function<TripPoint.TripPointValidationContext, Collection<ValidationMessage>> function, ValidationMessage validationMessage) {
        String str = tripPointStringFunction.apply(tripPoint);
        if (TextUtil.isBlank((String)str) || predicate.test(str)) {
            function.apply(tripPoint.getValidationContext()).add(validationMessage);
        }
    }
}

