/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.ibus.search;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.transfers.rules.TransferParametersActions;
import com.gridnine.xtrip.common.transfers.rules.TransferParametersProperties;
import com.gridnine.xtrip.common.transfers.rules.TransferTargets;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import org.apache.commons.lang.BooleanUtils;

public class ApplicableTransferAccountsProvider
extends BaseTargetsProvider<EntityContainer<BaseGdsAccount>> {
    public Collection<EntityContainer<BaseGdsAccount>> getTargets(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityContainer accountCtr = (EntityContainer)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        RuleSet rules = SalesContextHandler.get().getRules(salesContext);
        RuleProxy proxy = new RuleProxy();
        boolean proxyTracerEnabled = BooleanUtils.isTrue((Boolean)((Boolean)ctx.getObject((Enum)IBusGdsContextKeys.PROXY_TRACER_ENABLED)));
        proxy.getTracer().setDisabled(!proxyTracerEnabled);
        proxy.setProxyType(TransferTargets.TRANSFER_PARAMETERS.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new TransferParametersProperties(null, null, salesContext, proxy));
        proxy.setActionSet((Object)new TransferParametersActions());
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
        if (accountCtr != null) {
            if (((BaseGdsAccount)accountCtr.getEntity()).getGds() == null) {
                throw Xeption.forAdmin((String)"\u0423 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0} \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f.", (Object[])new Object[]{((BaseGdsAccount)accountCtr.getEntity()).getName()});
            }
            if (!((TransferParametersActions)proxy.getActionSet()).getApplicableGdsAccounts().contains(accountCtr.toReference())) {
                return Collections.emptyList();
            }
            return Collections.singleton(accountCtr);
        }
        HashSet<EntityContainer<BaseGdsAccount>> result = new HashSet<EntityContainer<BaseGdsAccount>>();
        for (EntityReference ref : ((TransferParametersActions)proxy.getActionSet()).getApplicableGdsAccounts()) {
            if (ref == null) continue;
            EntityContainer ctr = EntityStorage.get().resolve(ref);
            if (this.validGdsAccount((EntityContainer<BaseGdsAccount>)ctr)) {
                result.add((EntityContainer<BaseGdsAccount>)ctr);
                continue;
            }
            ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0423\u043a\u0430\u0437\u0430\u043d \u043d\u0435\u0432\u0430\u043b\u0438\u0434\u043d\u044b\u0439 \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0}", (Object[])new Object[]{ref.getCaption()}));
        }
        return result;
    }

    private boolean validGdsAccount(EntityContainer<BaseGdsAccount> ctr) {
        if (ctr == null) {
            return false;
        }
        return ((BaseGdsAccount)ctr.getEntity()).getGds() != null;
    }
}

