/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.ibus.search;

import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.transfers.SearchGdsResponse;
import com.gridnine.xtrip.server.transfers.SearchResponse;
import com.gridnine.xtrip.server.transfers.ibus.IBusTransfersContextKeys;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class AssembleGroupResultsProcessor
extends BaseProcessor {
    public static final String DIRECTION = "backDirection";
    private boolean backDirection;

    public void configure(Map<String, String> parameters) {
        if (parameters.containsKey(DIRECTION)) {
            this.backDirection = Boolean.parseBoolean(parameters.get(DIRECTION));
        }
    }

    public void process(MessageContext ctx) throws Exception {
        List gdsResult = (List)ctx.getMandatoryObject((Enum)IBusTransfersContextKeys.TRANSFERS_GDS_SEARCH_RESPONSE);
        if (!this.backDirection) {
            List<SearchResponse> mainResult = this.setToTrips(gdsResult);
            ctx.putObject((Enum)IBusTransfersContextKeys.TRANSFERS_SEARCH_RESPONSE, mainResult);
            return;
        }
        this.setFromTrips(ctx, gdsResult);
        ctx.removeObject((Enum)IBusTransfersContextKeys.TRANSFERS_GDS_SEARCH_RESPONSE);
    }

    private List<SearchResponse> setToTrips(List<SearchGdsResponse> gdsResult) {
        ArrayList<SearchResponse> mainResult = new ArrayList<SearchResponse>();
        for (SearchGdsResponse gdsResponse : gdsResult) {
            SearchResponse response = new SearchResponse();
            response.setTo(gdsResponse);
            mainResult.add(response);
        }
        return mainResult;
    }

    private void setFromTrips(MessageContext ctx, List<SearchGdsResponse> gdsResult) {
        List mainResult = (List)ctx.getMandatoryObject((Enum)IBusTransfersContextKeys.TRANSFERS_SEARCH_RESPONSE);
        ListIterator searchResponseListIterator = mainResult.listIterator();
        block0: while (searchResponseListIterator.hasNext()) {
            SearchResponse mainResponse = (SearchResponse)searchResponseListIterator.next();
            for (SearchGdsResponse item : gdsResult) {
                if (!this.isSearchItemsMatch(mainResponse, item)) continue;
                mainResponse.setFrom(item);
                continue block0;
            }
            if (mainResponse.getFrom() != null) continue;
            this.log.warn(String.format("Not found from trip, gdsAccount [%s]", mainResponse.getTo().getGdsAccount()));
            searchResponseListIterator.remove();
        }
    }

    private boolean isSearchItemsMatch(SearchResponse mainResponse, SearchGdsResponse item) {
        if (!MiscUtil.equals((Object)mainResponse.getTo().getGdsAccount(), (Object)item.getGdsAccount())) {
            return false;
        }
        if (!mainResponse.getTo().getCarClass().getCarClassDict().equals((Object)item.getCarClass().getCarClassDict())) {
            return false;
        }
        if (!mainResponse.getTo().getCarClass().getModels().equals(item.getCarClass().getModels())) {
            return false;
        }
        return mainResponse.getTo().getCarClass().getCapacity().equals(item.getCarClass().getCapacity());
    }
}

