/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.ibus.search;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.transfers.SearchGdsResponse;
import com.gridnine.xtrip.server.transfers.SearchResponse;
import com.gridnine.xtrip.server.transfers.ibus.IBusTransfersContextKeys;
import java.util.List;

public class BookingToSearchResponseConverter
extends BaseProcessor {
    public void process(MessageContext ctx) {
        EntityContainer bookingFileEntityContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        BookingFile bookingFile = (BookingFile)bookingFileEntityContainer.getEntity();
        List searchResponses = (List)ctx.getMandatoryObject((Enum)IBusTransfersContextKeys.TRANSFERS_SEARCH_RESPONSE);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        boolean isSaveRulesTraces = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        searchResponses.forEach(sr -> {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u041f\u0440\u0430\u0432\u0438\u043b\u0430 \u0434\u043b\u044f \u0442\u0440\u0430\u043d\u0441\u0444\u0435\u0440\u0430 \u0442\u0443\u0434\u0430:");
            this.update(sr.getTo(), bookingFile, stringBuilder);
            if (sr.getFrom() != null) {
                stringBuilder.append("\n\u041f\u0440\u0430\u0432\u0438\u043b\u0430 \u0434\u043b\u044f \u0442\u0440\u0430\u043d\u0441\u0444\u0435\u0440\u0430 \u043e\u0431\u0440\u0430\u0442\u043d\u043e:");
                this.update(sr.getFrom(), bookingFile, stringBuilder);
            }
            this.saveResult(isSaveRulesTraces, (GdsTracingItemBuilder<SearchResponse>)builder, (SearchResponse)sr, stringBuilder);
        });
    }

    private void update(SearchGdsResponse searchGdsResponse, BookingFile bookingFile, StringBuilder stringBuilder) {
        if (searchGdsResponse == null) {
            return;
        }
        Reservation reservation = BookingHelper.findReservationByUid((BookingFile)bookingFile, (String)searchGdsResponse.getUid());
        if (reservation == null || reservation.getProducts().isEmpty()) {
            return;
        }
        BaseProduct product = (BaseProduct)reservation.getProducts().get(0);
        searchGdsResponse.getContractRelations().addAll(GeneralProductHelper.getUnmodifiableContractRelations((BaseProduct)product));
        reservation.getBookingFile().getAppliedRules().stream().filter(ar -> MiscUtil.equals((Object)ar.getProductUid(), (Object)product.getUid())).forEach(ar -> stringBuilder.append(String.format("\n\u0414\u043e\u0433\u043e\u0432\u043e\u0440 %s, \u043f\u0440\u0430\u0432\u0438\u043b\u043e %s, \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435: %s", ar.getContract(), ar.getRuleName(), ar.getRuleDescription())));
    }

    private void saveResult(boolean isSaveRulesTraces, GdsTracingItemBuilder<SearchResponse> builder, SearchResponse searchResponse, StringBuilder stringBuilder) {
        if (isSaveRulesTraces) {
            builder.traceFlightLogic((BaseEntity)searchResponse, MessageType.MESSAGE, stringBuilder.toString());
        }
    }
}

