/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.ibus.search;

import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.transfers.SearchGdsRequest;
import com.gridnine.xtrip.server.transfers.SearchRequest;
import com.gridnine.xtrip.server.transfers.ibus.IBusTransfersContextKeys;
import java.util.Map;

public class CreateGdsRequestProcessor
extends BaseProcessor {
    private boolean backDirection = false;

    public void configure(Map<String, String> parameters) {
        if (parameters.containsKey("backDirection")) {
            this.backDirection = Boolean.parseBoolean(parameters.get("backDirection"));
        }
    }

    public void process(MessageContext ctx) throws Exception {
        SearchRequest request = (SearchRequest)ctx.getMandatoryObject((Enum)IBusTransfersContextKeys.TRANSFERS_SEARCH_REQUEST);
        SearchGdsRequest gdsRequest = new SearchGdsRequest();
        gdsRequest.setTransferType(request.getTransferType());
        if (this.backDirection) {
            gdsRequest.setStartPlaceCoordinates(request.getEndPlaceCoordinates());
            gdsRequest.setEndPlaceCoordinates(request.getStartPlaceCoordinates());
        } else {
            gdsRequest.setStartPlaceCoordinates(request.getStartPlaceCoordinates());
            gdsRequest.setEndPlaceCoordinates(request.getEndPlaceCoordinates());
        }
        gdsRequest.getSubaddresses().addAll(request.getStartSubadresses());
        gdsRequest.setDuration(request.getDuration());
        ctx.putObject((Enum)IBusTransfersContextKeys.TRANSFERS_GDS_SEARCH_REQUEST, (Object)gdsRequest);
        ctx.putObject((Enum)IBusTransfersContextKeys.TRANSFERS_SEARCH_IS_BACK_DIRECTION, (Object)this.backDirection);
    }
}

