/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.ibus.search;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.transfers.GdsCarClass;
import com.gridnine.xtrip.server.transfers.SearchGdsResponse;
import com.gridnine.xtrip.server.transfers.SearchRequest;
import com.gridnine.xtrip.server.transfers.SearchResponse;
import com.gridnine.xtrip.server.transfers.ibus.IBusTransfersContextKeys;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class FilterSearchResultsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SearchRequest request = (SearchRequest)ctx.getMandatoryObject((Enum)IBusTransfersContextKeys.TRANSFERS_SEARCH_REQUEST);
        if (request.getCapacity() != null) {
            List response = (List)ctx.getMandatoryObject((Enum)IBusTransfersContextKeys.TRANSFERS_SEARCH_RESPONSE);
            GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
            GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
            boolean isSaveRulesTraces = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
            Iterator iterator = response.iterator();
            while (iterator.hasNext()) {
                SearchResponse sr = (SearchResponse)iterator.next();
                Integer minCapacity = Stream.of(sr.getTo(), sr.getFrom()).filter(Objects::nonNull).map(SearchGdsResponse::getCarClass).filter(Objects::nonNull).map(GdsCarClass::getCapacity).filter(Objects::nonNull).min(Integer::compareTo).orElse(0);
                if (minCapacity <= request.getCapacity()) continue;
                if (isSaveRulesTraces) {
                    builder.traceFlightLogic((BaseEntity)sr, MessageType.MESSAGE, "transfer was excluded from result because min capacity " + minCapacity + " > request capacity " + request.getCapacity());
                }
                iterator.remove();
            }
        }
    }
}

