/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.ibus.search;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.transfers.TransferType;
import com.gridnine.xtrip.common.model.transfers.TransferReservationCreationParameters;
import com.gridnine.xtrip.common.transfers.GdsPlaceInfo;
import com.gridnine.xtrip.common.transfers.TripDetails;
import com.gridnine.xtrip.common.transfers.TripPoint;
import com.gridnine.xtrip.common.transfers.model.BaseTransferGdsAccount;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.transfers.GdsCarClass;
import com.gridnine.xtrip.server.transfers.SearchGdsResponse;
import com.gridnine.xtrip.server.transfers.SearchRequest;
import com.gridnine.xtrip.server.transfers.SubaddressInfo;
import com.gridnine.xtrip.server.transfers.ibus.IBusTransfersContextKeys;
import java.time.LocalDateTime;

public class PrepareReservationParametersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        SearchGdsResponse searchResponse = (SearchGdsResponse)ctx.getMandatoryObject((Enum)IBusTransfersContextKeys.TRANSFERS_SEARCH_GDS_RESPONSE);
        SearchRequest searchRequest = (SearchRequest)ctx.getObject((Enum)IBusTransfersContextKeys.TRANSFERS_SEARCH_REQUEST);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        TransferReservationCreationParameters transferReservationCreationParameters = this.getTransferReservationCreationParameters(searchResponse, (EntityContainer<BaseTransferGdsAccount>)accountCtr, searchRequest);
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS, (Object)transferReservationCreationParameters);
    }

    private TransferReservationCreationParameters getTransferReservationCreationParameters(SearchGdsResponse searchResponse, EntityContainer<BaseTransferGdsAccount> accountCtr, SearchRequest searchRequest) {
        TransferReservationCreationParameters trancferParametrs = new TransferReservationCreationParameters();
        trancferParametrs.setTransferType(TransferType.TRANSFER);
        trancferParametrs.setCurrency(searchResponse.getGdsCurrency());
        trancferParametrs.setGdsAccount(accountCtr.toReference());
        TripDetails tripDetails = new TripDetails();
        TripPoint startTripPoint = new TripPoint();
        startTripPoint.setTime(MiscUtil.toDate((LocalDateTime)searchRequest.getStartDate()));
        tripDetails.setStart(startTripPoint);
        tripDetails.setEnd(new TripPoint());
        SearchGdsResponse searchGdsResponse = new SearchGdsResponse();
        searchGdsResponse.setPrice(searchResponse.getPrice());
        SubaddressInfo subaddressInfo = new SubaddressInfo();
        subaddressInfo.setPriceSubaddress(searchResponse.getSubaddressInfo().getPriceSubaddress());
        searchGdsResponse.setSubaddressInfo(subaddressInfo);
        GdsCarClass carClass = new GdsCarClass();
        carClass.setCarClassDict(searchResponse.getCarClass().getCarClassDict());
        carClass.setImageUrl(searchResponse.getCarClass().getImageUrl());
        carClass.setCapacity(searchResponse.getCarClass().getCapacity());
        carClass.setModels(String.join((CharSequence)", ", searchResponse.getCarClass().getModels()));
        searchGdsResponse.setCarClass(carClass);
        searchGdsResponse.setStartPlace(new GdsPlaceInfo());
        searchGdsResponse.setEndPlace(new GdsPlaceInfo());
        searchGdsResponse.setFlexibleTariff(searchResponse.isFlexibleTariff());
        searchGdsResponse.setFlexibleTariffAgreement(searchResponse.isFlexibleTariffAgreement());
        searchGdsResponse.setCancellationNoPenaltyHours(searchResponse.getCancellationNoPenaltyHours());
        tripDetails.setFlexibleTariff(searchResponse.isFlexibleTariff());
        tripDetails.setFlexibleTariffAgreement(searchResponse.isFlexibleTariffAgreement());
        tripDetails.setCancellationNoPenaltyHours(searchResponse.getCancellationNoPenaltyHours());
        tripDetails.getSubAddresses().addAll(searchRequest.getStartSubadresses());
        tripDetails.setSearchGdsResponse(searchGdsResponse);
        tripDetails.setChildCount(searchRequest.getChildCount().intValue());
        tripDetails.setAdultCount(searchRequest.getAdultCount().intValue());
        trancferParametrs.setTripDetails(tripDetails);
        return trancferParametrs;
    }
}

