/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.ibus.search;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.transfers.rules.TransferParametersActions;
import com.gridnine.xtrip.common.transfers.rules.TransferParametersProperties;
import com.gridnine.xtrip.common.transfers.rules.TransferTargets;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.transfers.SearchGdsResponse;
import com.gridnine.xtrip.server.transfers.SearchResponse;
import com.gridnine.xtrip.server.transfers.ibus.IBusTransfersContextKeys;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class SearchResultApplyRulesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List responses = (List)ctx.getMandatoryObject((Enum)IBusTransfersContextKeys.TRANSFERS_SEARCH_RESPONSE);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        RuleSet rules = SalesContextHandler.get().getRules(salesContext);
        EntityStorageContext storageContext = new EntityStorageContext();
        boolean isSaveRulesTraces = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        Iterator iterator = responses.iterator();
        while (iterator.hasNext()) {
            SearchResponse searchResponse = (SearchResponse)iterator.next();
            RuleProxy<TransferParametersProperties, TransferParametersActions> proxyFrom = this.isExcludedFromResult(salesContext, searchResponse.getFrom(), storageContext, rules);
            RuleProxy<TransferParametersProperties, TransferParametersActions> proxyTo = this.isExcludedFromResult(salesContext, searchResponse.getTo(), storageContext, rules);
            if (proxyFrom != null && ((TransferParametersActions)proxyFrom.getActionSet()).isExcludeFromResult()) {
                iterator.remove();
                this.saveResult(isSaveRulesTraces, proxyFrom, rules, (GdsTracingItemBuilder<SearchResponse>)builder, searchResponse);
                this.saveExcludedResult(isSaveRulesTraces, (GdsTracingItemBuilder<SearchResponse>)builder, searchResponse);
                continue;
            }
            if (proxyTo == null || !((TransferParametersActions)proxyTo.getActionSet()).isExcludeFromResult()) continue;
            iterator.remove();
            this.saveResult(isSaveRulesTraces, proxyTo, rules, (GdsTracingItemBuilder<SearchResponse>)builder, searchResponse);
            this.saveExcludedResult(isSaveRulesTraces, (GdsTracingItemBuilder<SearchResponse>)builder, searchResponse);
        }
    }

    private RuleProxy<TransferParametersProperties, TransferParametersActions> isExcludedFromResult(SalesContext salesContext, SearchGdsResponse gdsResponse, EntityStorageContext storageContext, RuleSet rules) throws Exception {
        if (gdsResponse == null) {
            return null;
        }
        EntityReference gdsAccountRef = gdsResponse.getGdsAccount();
        EntityContainer gdsAccountCtr = EntityStorageHelper.resolve((EntityReference)gdsAccountRef, (EntityStorageContext)storageContext);
        RuleProxy proxy = new RuleProxy();
        proxy.setProxyType(TransferTargets.TRANSFER_PARAMETERS.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new TransferParametersProperties(gdsAccountCtr == null ? null : ((BaseGdsAccount)gdsAccountCtr.getEntity()).getGds(), gdsAccountRef, salesContext, proxy));
        proxy.setActionSet((Object)new TransferParametersActions());
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
        return proxy;
    }

    private void saveResult(boolean isSaveRulesTraces, RuleProxy<TransferParametersProperties, TransferParametersActions> proxy, RuleSet rules, GdsTracingItemBuilder<SearchResponse> builder, SearchResponse searchResponse) {
        if (isSaveRulesTraces) {
            for (String ruleUid : proxy.getAppliedRules()) {
                RuleSettings rs = (RuleSettings)CollectionUtil.find((Iterable)rules.getRules(), (String)ruleUid);
                if (rs == null) continue;
                builder.traceFlightLogic((BaseEntity)searchResponse, MessageType.MESSAGE, String.format("rule %s was applied: %s", rs.getName(), rs.getRestrictionsInfoNoHtml()));
            }
        }
    }

    private void saveExcludedResult(boolean isSaveRulesTraces, GdsTracingItemBuilder<SearchResponse> builder, SearchResponse searchResponse) {
        if (isSaveRulesTraces) {
            builder.traceFlightLogic((BaseEntity)searchResponse, MessageType.MESSAGE, "transfer was excluded from result due to rules restriction");
        }
    }
}

