/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.iway;

import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.transfers.TransferReservationCreationParameters;
import com.gridnine.xtrip.common.transfers.TransfersValidationMessages;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Objects;

public class ValidateIWayPhoneNumberFormatProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Collection creationParametersList = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATIONS_CREATION_PARAMETERS);
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        creationParametersList.stream().map(TransferReservationCreationParameters::getCustomer).filter(Objects::nonNull).filter(c -> this.invalidPhone(c.getPhone())).forEach(c -> c.getPhone().getValidationContext().getSenseValidationMessages().add(TransfersValidationMessages.getInvalidPhoneError()));
        travellers.forEach(t -> t.getCommunications().stream().filter(this::invalidPhone).forEach(c -> c.getValidationContext().getSenseValidationMessages().add(TransfersValidationMessages.getInvalidPhoneError())));
    }

    private boolean invalidPhone(Communication communication) {
        if (communication == null || !this.isPhone(communication.getType())) {
            return false;
        }
        if (TextUtil.isBlank((String)communication.getCityCode()) || TextUtil.isBlank((String)communication.getSense())) {
            return true;
        }
        Integer code = TextUtil.toInteger((String)communication.getCountryCode());
        if (code == null) {
            return true;
        }
        Long number = TextUtil.toLong((String)(communication.getCityCode() + communication.getSense()));
        if (number == null) {
            return true;
        }
        PhoneNumberUtil util = PhoneNumberUtil.getInstance();
        Phonenumber.PhoneNumber phoneNumber = new Phonenumber.PhoneNumber();
        phoneNumber.setCountryCode(code.intValue());
        phoneNumber.setNationalNumber(number.longValue());
        return !util.isValidNumber(phoneNumber);
    }

    private boolean isPhone(CommunicationType type) {
        return CommunicationType.WORK_PHONE == type || CommunicationType.HOME_PHONE == type || CommunicationType.MOBILE == type || CommunicationType.CELL == type;
    }
}

