/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.iway.assets;

import com.gridnine.xtrip.common.transfers.iway.model.IwayToken;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Index;

@Entity
public class IwayTokenAssetData
extends BaseAssetData<IwayToken> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="IwayTokenAssetData_modified")
    private Date modified;
    @Column(unique=true)
    @Index(name="IwayTokenAssetData_gdsAccountUid")
    private String gdsAccountUid;
    @Column(length=2048)
    private String tokenString;

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date date) {
        this.modified = date;
    }

    public void fromAsset(IwayToken asset) {
        this.setUid(asset.getUid());
        this.modified = asset.getModified();
        this.gdsAccountUid = asset.getGdsAccountUid();
        this.tokenString = asset.getTokenString();
    }

    public IwayToken toAsset(Set<String> preferredProperties) {
        IwayToken result = new IwayToken(this.getUid());
        result.setModified(MiscUtil.cloneDate((Date)this.modified));
        if (preferredProperties.isEmpty() || preferredProperties.contains("gdsAccountUid")) {
            result.setGdsAccountUid(this.gdsAccountUid);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("tokenString")) {
            result.setTokenString(this.tokenString);
        }
        return result;
    }
}

