/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.iway.db.update;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class PopulateTransfersIwayGeoLocationCodesHandler
implements SetupUpdateHandler {
    private static final Logger logger = LoggerFactory.getLogger(PopulateTransfersIwayGeoLocationCodesHandler.class);

    public void execute(Element command) throws Exception {
        GeoLocation dbEntry;
        List<GeoLocation> dbEntries;
        List csvData;
        Map<String, String> csvCountries;
        Object br2;
        Object isr;
        DictionaryCache dc = DictionaryCache.get();
        DictionaryStorage ds = DictionaryStorage.get();
        try (InputStream is = this.getClass().getResourceAsStream("country_202304271049.csv");){
            isr = new InputStreamReader(is);
            Throwable throwable = null;
            try {
                br2 = new BufferedReader((Reader)isr);
                Throwable throwable2 = null;
                try {
                    csvCountries = ((BufferedReader)br2).lines().map(line -> line.split(",")).collect(Collectors.toMap(cols -> cols[0], cols -> PopulateTransfersIwayGeoLocationCodesHandler.clearName(cols[1])));
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (br2 != null) {
                        if (throwable2 != null) {
                            try {
                                ((BufferedReader)br2).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                        } else {
                            ((BufferedReader)br2).close();
                        }
                    }
                }
            }
            catch (Throwable br2) {
                throwable = br2;
                throw br2;
            }
            finally {
                if (isr != null) {
                    if (throwable != null) {
                        try {
                            ((InputStreamReader)isr).close();
                        }
                        catch (Throwable br2) {
                            throwable.addSuppressed(br2);
                        }
                    } else {
                        ((InputStreamReader)isr).close();
                    }
                }
            }
        }
        InputStream is = this.getClass().getResourceAsStream("city_202304271049.csv");
        isr = null;
        try {
            InputStreamReader isr2 = new InputStreamReader(is);
            br2 = null;
            try (BufferedReader br32 = new BufferedReader(isr2);){
                csvData = br32.lines().map(line -> line.split(",")).collect(Collectors.toList());
            }
            catch (Throwable br32) {
                br2 = br32;
                throw br32;
            }
            finally {
                if (isr2 != null) {
                    if (br2 != null) {
                        try {
                            isr2.close();
                        }
                        catch (Throwable br32) {
                            ((Throwable)br2).addSuppressed(br32);
                        }
                    } else {
                        isr2.close();
                    }
                }
            }
        }
        catch (Throwable isr2) {
            isr = isr2;
            throw isr2;
        }
        finally {
            if (is != null) {
                if (isr != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable isr2) {
                        ((Throwable)isr).addSuppressed(isr2);
                    }
                } else {
                    is.close();
                }
            }
        }
        Map<String, String> csvIata = csvData.stream().filter(cols -> ((String[])cols).length > 3).collect(Collectors.toMap(cols -> cols[3], cols -> cols[0]));
        Map<String, String> csvName = csvData.stream().filter(cols -> ((String[])cols).length == 3).collect(Collectors.groupingBy(cols -> String.join((CharSequence)"|", PopulateTransfersIwayGeoLocationCodesHandler.clearName(cols[2]), (CharSequence)csvCountries.get(cols[1])))).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() == 1).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((String[])((List)entry.getValue()).get(0))[0]));
        Map<String, List<GeoLocation>> dbIata = dc.getAll(GeoLocation.class).values().stream().filter(geo -> geo.getType() == LocationType.CITY).filter(geo -> geo.getCodeVariants().containsKey(CodeSystem.IATA.name())).collect(Collectors.groupingBy(geo -> (String)geo.getCodeVariants().get(CodeSystem.IATA.name())));
        Map<String, List<GeoLocation>> dbName = dc.getAll(GeoLocation.class).values().stream().filter(geo -> geo.getType() == LocationType.CITY).filter(geo -> dc.resolveReference(geo.getCountry()) != null).filter(geo -> geo.getTranslations().keySet().stream().anyMatch(lang -> "ru".equals(lang.getLanguage()))).collect(Collectors.groupingBy(geo -> String.join((CharSequence)"|", PopulateTransfersIwayGeoLocationCodesHandler.clearName(PopulateTransfersIwayGeoLocationCodesHandler.getRuTranslation((BaseDictionary)geo)), PopulateTransfersIwayGeoLocationCodesHandler.clearName(PopulateTransfersIwayGeoLocationCodesHandler.getRuTranslation(dc.resolveReference(geo.getCountry()))))));
        int iata = 0;
        int name = 0;
        int total = 0;
        HashSet<String> iataModified = new HashSet<String>();
        for (Map.Entry<String, String> csvEntry : csvIata.entrySet()) {
            dbEntries = dbIata.get(csvEntry.getKey());
            if (dbEntries != null) {
                if (dbEntries.size() == 1) {
                    dbEntry = dbEntries.get(0);
                    if (dbEntry.getCodeVariants().containsKey(CodeSystem.TRANSFERS_IWAY.name())) {
                        logger.warn("Geolocation with code {} was not updated because it already contained TRANSFERS_IWAY code", (Object)dbEntry.getCode());
                    } else {
                        dbEntry.getCodeVariants().put(CodeSystem.TRANSFERS_IWAY.name(), csvEntry.getValue());
                        dbEntry.setDataSource("PopulateTransfersIwayGeoLocationCodesHandler");
                        ds.save((BaseDictionary)dbEntry);
                        ++iata;
                        iataModified.add(dbEntry.getCode());
                    }
                } else {
                    logger.warn("IATA code {} found {} times in DB", (Object)csvEntry.getKey(), (Object)dbEntries.size());
                }
            } else {
                logger.warn("IATA code {} not found in DB", (Object)csvEntry.getKey());
            }
            ++total;
        }
        for (Map.Entry<String, String> csvEntry : csvName.entrySet()) {
            dbEntries = dbName.get(csvEntry.getKey());
            if (dbEntries != null) {
                if (dbEntries.size() == 1) {
                    dbEntry = dbEntries.get(0);
                    if (iataModified.contains(dbEntry.getCode())) {
                        logger.warn("Name {} skipped as it was already modified by IATA", (Object)csvEntry.getKey());
                    } else if (dbEntry.getCodeVariants().containsKey(CodeSystem.TRANSFERS_IWAY.name())) {
                        logger.warn("Geolocation with code {} was not updated because it already contained TRANSFERS_IWAY code", (Object)dbEntry.getCode());
                    } else {
                        dbEntry.getCodeVariants().put(CodeSystem.TRANSFERS_IWAY.name(), csvEntry.getValue());
                        dbEntry.setDataSource("PopulateTransfersIwayGeoLocationCodesHandler");
                        ds.save((BaseDictionary)dbEntry);
                        ++name;
                    }
                } else {
                    logger.warn("Name {} found {} times in DB", (Object)csvEntry.getKey(), (Object)dbEntries.size());
                }
            } else {
                logger.warn("Name {} not found in DB", (Object)csvEntry.getKey());
            }
            ++total;
        }
        logger.info("{} successful ({} by IATA, {} by name) out of {}", new Object[]{iata + name, iata, name, total});
    }

    private static String clearName(String name) {
        return name.toLowerCase().replaceAll("[^\u0430-\u044f\u0451]+", "").replaceAll("\u0451", "\u0435");
    }

    private static String getRuTranslation(BaseDictionary dict) {
        return (String)dict.getTranslations().entrySet().stream().filter(entry -> "ru".equals(((Locale)entry.getKey()).getLanguage())).findFirst().get().getValue();
    }
}

