/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.iway.geocoder;

import com.gridnine.xtrip.common.geocoder.model.GeocodeItem;
import com.gridnine.xtrip.common.geocoder.model.GeocoderType;
import com.gridnine.xtrip.common.midoffice.model.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.transfers.IWayGeocodeItem;
import com.gridnine.xtrip.common.model.transfers.IwayGdsAccount;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.geocoder.ibus.IBusGeocoderContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.transfers.iway.IBusGdsIwayContextKeys;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.FindPlacesRS;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FindPlacesRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) {
        FindPlacesRS response = (FindPlacesRS)ctx.getMandatoryObject((Enum)IBusGdsIwayContextKeys.IWAY_NG_RESPONSE);
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        ctx.putObject((Enum)IBusGeocoderContextKeys.GEOCODE_ITEMS, this.buildItems(response, (EntityReference<IwayGdsAccount>)gdsAccountCtr.toReference()));
    }

    private List<GeocodeItem> buildItems(FindPlacesRS response, EntityReference<IwayGdsAccount> gdsAccountRef) {
        if (CollectionUtil.isEmpty(response.getResult())) {
            return Collections.emptyList();
        }
        return response.getResult().stream().map(place -> this.buildItem((FindPlacesRS.Place)place, gdsAccountRef)).collect(Collectors.toList());
    }

    private GeocodeItem buildItem(FindPlacesRS.Place place, EntityReference<IwayGdsAccount> gdsAccountRef) {
        IWayGeocodeItem result = new IWayGeocodeItem();
        result.setType(GeocoderType.IWAY);
        result.setGdsAccount(gdsAccountRef);
        result.setGeocodeId(place.getPlaceId());
        String name = Stream.of(place.getStructuredFormatting().getSecondaryText(), place.getStructuredFormatting().getMainText()).filter(TextUtil::nonBlank).collect(Collectors.joining(", "));
        result.setName(name);
        return result;
    }
}

