/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.iway.geocoder;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.transfers.IWayGeocodeItem;
import com.gridnine.xtrip.server.geocoder.ibus.IBusGeocoderContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.transfers.iway.IBusGdsIwayContextKeys;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.GetPlaceInfoRS;
import java.util.Optional;

public class GetPlaceInfoRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) {
        IWayGeocodeItem geocodeItem = (IWayGeocodeItem)ctx.getMandatoryObject((Enum)IBusGeocoderContextKeys.GEOCODE_ITEM);
        GetPlaceInfoRS response = (GetPlaceInfoRS)ctx.getMandatoryObject((Enum)IBusGdsIwayContextKeys.IWAY_NG_RESPONSE);
        this.updateItems(geocodeItem, response);
    }

    private void updateItems(IWayGeocodeItem geocodeItem, GetPlaceInfoRS response) {
        GetPlaceInfoRS.Location location = Optional.ofNullable(response).map(GetPlaceInfoRS::getResult).map(GetPlaceInfoRS.PlaceInfo::getGeometry).map(GetPlaceInfoRS.Geometry::getLocation).orElse(null);
        if (location != null) {
            geocodeItem.setLatitude(location.getLat());
            geocodeItem.setLongitude(location.getLng());
            if (location.getLat() == null) {
                IncidentsLog.reportStackTrace((String)("iway geocode item " + geocodeItem.getGeocodeId() + " hasn't lat"));
            }
            if (location.getLng() == null) {
                IncidentsLog.reportStackTrace((String)("iway geocode item " + geocodeItem.getGeocodeId() + " hasn't lng"));
            }
        } else {
            IncidentsLog.reportStackTrace((String)("iway geocode item " + geocodeItem.getGeocodeId() + " hasn't location"));
        }
    }
}

