/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.iway.nextgen;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.transfers.iway.IWayErrorTranslator;
import com.gridnine.xtrip.server.transfers.iway.nextgen.exception.UnauthorizedException;
import com.gridnine.xtrip.server.transfers.iway.nextgen.helpers.IwayAPIHelper;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.ErrorRS;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public abstract class IwayNgAbstractHttpResponseParser
extends BaseProcessor {
    private static final List<Integer> UNAUTHORIZED_RESPOMSE_CODES = Arrays.asList(401, 403);

    protected void checkResponse(HttpRequest request, HttpResponse response) {
        this.checkResponse(request, response, false);
    }

    protected void checkResponse(HttpRequest request, HttpResponse response, boolean ignoreError) {
        if (response.getBody() != null) {
            return;
        }
        if (UNAUTHORIZED_RESPOMSE_CODES.contains(response.getResponseCode())) {
            String token = Optional.ofNullable(request.getRequestProperties().get((Object)"Authorization")).map(auth -> auth.replaceFirst("Bearer\\s", "")).orElse("");
            throw new UnauthorizedException(token);
        }
        if (ignoreError && response.getError() != null) {
            return;
        }
        this.parserError(response);
        if (response.getResponseCode() == 204) {
            return;
        }
        throw Xeption.forDeveloper((String)"response is null, code = {0}, message = {1}", (Object[])new Object[]{response.getResponseCode(), response.getResponseMessage()});
    }

    private void parserError(HttpResponse response) {
        if (response.getError() != null) {
            ErrorRS errorRS = null;
            try {
                errorRS = (ErrorRS)IwayAPIHelper.MAPPER.readValue(response.getError(), ErrorRS.class);
            }
            catch (Exception e) {
                this.log.debug("error parser errorRS", (Throwable)e);
            }
            IWayErrorTranslator.checkError(errorRS);
            String errorContent = new String(response.getError());
            throw Xeption.forDeveloper((String)"error: {0}", (Object[])new Object[]{errorContent});
        }
    }
}

