/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.iway.nextgen;

import com.gridnine.xtrip.common.midoffice.model.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.helpers.ValidationUtil;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.model.transfers.IwayGdsAccount;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.transfers.iway.model.IwayToken;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.gridnine.xtrip.server.transfers.iway.IBusGdsIwayContextKeys;
import com.gridnine.xtrip.server.transfers.iway.nextgen.helpers.IwayAPIHelper;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.IwayNgRequestParams;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class IwayNgHttpRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        IwayNgRequestParams requestParams = (IwayNgRequestParams)ctx.getMandatoryObject((Enum)IBusGdsIwayContextKeys.IWAY_NG_REQUEST_PARAMS);
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        String agentId = IwayAPIHelper.getAgentId((EntityReference<Person>)salesContext.getAgent());
        if (ValidationUtil.containsOnlyDigits((String)agentId)) {
            requestParams.getUrlParameters().put("user_id", new String[]{agentId});
        }
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(IwayAPIHelper.buildUrl(requestParams, (IwayGdsAccount)gdsAccountCtr.getEntity()));
        httpRequest.setRequestMethod(requestParams.getOperation().getRequestMethod());
        httpRequest.getRequestProperties().put((Object)"Content-Type", (Object)"application/json");
        httpRequest.setBody(this.buildContent(requestParams.getRequest()));
        httpRequest.getQueryParameters().putAll(requestParams.getUrlParameters());
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)IwayToken.Property.gdsAccountUid.name(), (Object)gdsAccountCtr.getUid()));
        query.setLimit(1);
        List data = AssetsStorage.get().search(IwayToken.class, query).getData();
        if (!data.isEmpty()) {
            httpRequest.getRequestProperties().put((Object)"Authorization", (Object)("Bearer " + ((IwayToken)data.get(0)).getTokenString()));
        }
        ctx.putObject((Enum)IBusHttpContextKeys.HTTP_REQUEST, (Object)httpRequest);
    }

    private byte[] buildContent(Object request) throws Exception {
        String content = IwayAPIHelper.MAPPER.writeValueAsString(request);
        return content.getBytes(StandardCharsets.UTF_8);
    }
}

