/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.iway.nextgen;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.gridnine.xtrip.server.transfers.iway.IBusGdsIwayContextKeys;
import com.gridnine.xtrip.server.transfers.iway.IWayErrorTranslator;
import com.gridnine.xtrip.server.transfers.iway.nextgen.IwayNgAbstractHttpResponseParser;
import com.gridnine.xtrip.server.transfers.iway.nextgen.helpers.IwayAPIHelper;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.ErrorRS;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.IwayNgRequestParams;

public class IwayNgHttpResponseParser
extends IwayNgAbstractHttpResponseParser {
    public void process(MessageContext ctx) throws Exception {
        IwayNgRequestParams reqParams = (IwayNgRequestParams)ctx.getMandatoryObject((Enum)IBusGdsIwayContextKeys.IWAY_NG_REQUEST_PARAMS);
        HttpRequest httpRequest = (HttpRequest)ctx.getMandatoryObject((Enum)IBusHttpContextKeys.HTTP_REQUEST);
        HttpResponse httpResponse = (HttpResponse)ctx.getMandatoryObject((Enum)IBusHttpContextKeys.HTTP_RESPONSE);
        this.checkResponse(httpRequest, httpResponse, false);
        Object response = this.parseHttpResponse(httpResponse, reqParams.getOperation().getResponseClass());
        if (response instanceof ErrorRS) {
            IWayErrorTranslator.checkError((ErrorRS)response);
        }
        ctx.putObject((Enum)IBusGdsIwayContextKeys.IWAY_NG_RESPONSE, response);
    }

    private Object parseHttpResponse(HttpResponse httpResponse, Class responseClass) throws Exception {
        if (httpResponse.getError() != null) {
            String error = new String(httpResponse.getError());
            throw Xeption.forDeveloper((String)"error: {0}", (Object[])new Object[]{error});
        }
        if (responseClass == null) {
            return null;
        }
        String body = new String(httpResponse.getBody());
        return IwayAPIHelper.MAPPER.readValue(body, responseClass);
    }
}

